# Copyright (c) DataLab Platform Developers, BSD 3-Clause license, see LICENSE file.

"""Module containing SVG icons for the application"""

DATALAB = """<?xml version="1.0" encoding="UTF-8" standalone="no"?>
<!-- Created with Inkscape (http://www.inkscape.org/) -->

<svg
   version="1.1"
   id="svg3157"
   xml:space="preserve"
   width="600"
   height="600"
   viewBox="0 0 599.99997 599.99997"
   sodipodi:docname="DataLab.svg"
   inkscape:version="1.2.2 (732a01da63, 2022-12-09)"
   inkscape:export-filename="DataLab.png"
   inkscape:export-xdpi="192"
   inkscape:export-ydpi="192"
   xmlns:inkscape="http://www.inkscape.org/namespaces/inkscape"
   xmlns:sodipodi="http://sodipodi.sourceforge.net/DTD/sodipodi-0.dtd"
   xmlns="http://www.w3.org/2000/svg"
   xmlns:svg="http://www.w3.org/2000/svg"
   xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#"
   xmlns:cc="http://creativecommons.org/ns#"
   xmlns:dc="http://purl.org/dc/elements/1.1/"><metadata
     id="metadata3163"><rdf:RDF><cc:Work
         rdf:about=""><dc:format>image/svg+xml</dc:format><dc:type
           rdf:resource="http://purl.org/dc/dcmitype/StillImage" /></cc:Work></rdf:RDF></metadata><defs
     id="defs3161"><marker
       markerWidth="700"
       markerHeight="700"
       refX="350"
       refY="350"
       orient="auto"
       id="marker1068"><g
         inkscape:label="Clip"
         id="use859"
         transform="matrix(1.3061145,0,0,-1.0907137,-173.85658,852.94723)"><path
           d="m 375.35627,684.77075 c 2.504,1.333 5.022,2.631 7.587,3.8 2.533,1.248 5.143,2.288 7.725,3.409 2.596,1.086 5.238,2.036 7.852,3.061 l 1.278,0.501 1.321,-0.562 c 2.774,-1.168 5.523,-2.384 8.276,-3.596 2.695,-1.349 5.471,-2.501 8.099,-4.009 l 7.965,-4.338 c 2.557,-1.683 5.206,-3.14 7.684,-5.013 l -0.075,-0.185 h -0.004 l -0.076,-0.186 -0.506,0.206 -32.744,13.383 -31.136,-11.089 -0.472,-0.169 -0.137,0.375 c 2.384,1.669 4.91,2.936 7.363,4.412 m 86.771,47.215 v -0.666 c 0,0 -1.409,-17.827 -1.743,-16.911 -0.331,0.915 -6.65,11.412 -6.65,11.412 z m -5.992,-32.821 c 12.277,2.727 18.745,21.492 34.738,15.494 0,0 -18.493,28.49 -27.991,23.492 -6.091,-3.207 -19.579,-12.783 -28.473,-19.243 l -21.835,-12.496 15.235,4.231 c 4.437,-4.393 15.996,-14.219 28.326,-11.478 m -119.158,28.821 8.583,-6.164 c 0,0 -6.411,-10.496 -6.74,-11.412 -0.333,-0.916 -1.843,16.91 -1.843,16.91 z m 2.871,-28.821 c 11.618,-2.583 22.546,5.988 27.482,10.662 l 14.863,-5.198 -12.68,8.459 c -3.951,2.931 -27.716,20.486 -36.413,25.063 -9.495,4.998 -27.988,-23.492 -27.988,-23.492 15.994,5.998 22.462,-12.767 34.736,-15.494 m 286.235,12.994 c -42.654,38.986 -105.963,-7.995 -105.963,-7.995 0,0 -17.743,20.826 -15.079,41.484 2.662,20.658 103.961,31.489 137.723,-26.378 53.335,-91.414 -85.548,-257.019 -85.548,-257.019 93.965,140.949 90.877,229.79 68.867,249.908 m -103.954,-262.832 c -4.262,-8.849 -8.031,-17.324 -11.354,-25.216 -1.553,-3.989 -3.045,-7.811 -4.458,-11.446 -1.29,-3.684 -2.507,-7.179 -3.656,-10.463 -2.018,-6.651 -3.743,-12.491 -4.705,-17.399 -1.182,-4.876 -1.745,-8.775 -2.167,-11.434 -0.43,-2.663 -0.659,-4.086 -0.659,-4.086 0,0 0.078,1.436 0.226,4.129 0.175,2.688 0.211,6.68 1.069,11.663 0.583,5.033 1.852,11.037 3.37,17.932 0.899,3.409 1.856,7.042 2.864,10.868 1.214,3.766 2.49,7.726 3.823,11.857 2.885,8.183 6.219,16.981 10.213,26.071 3.93,9.122 8.302,18.632 13.128,28.302 4.8,9.687 9.806,19.653 15.116,29.65 5.256,10.001 10.595,20.168 15.936,30.329 10.688,20.27 20.919,40.732 28.881,60.495 3.943,9.897 7.171,19.637 9.687,29.018 0.956,4.729 2.232,9.313 2.722,13.823 0.292,2.247 0.721,4.46 0.894,6.637 0.12,2.186 0.238,4.328 0.355,6.427 0.215,2.111 -0.015,4.153 -0.086,6.163 -0.149,1.998 -0.077,3.993 -0.375,5.878 -0.684,3.748 -0.89,7.45 -2.067,10.677 -0.478,1.647 -0.943,3.245 -1.392,4.784 -0.477,1.533 -1.238,2.89 -1.808,4.265 -0.609,1.364 -1.195,2.672 -1.757,3.923 -0.567,1.246 -1.371,2.273 -1.996,3.342 -1.355,2.065 -2.413,4.032 -3.581,5.598 -1.237,1.512 -2.288,2.801 -3.139,3.846 -1.707,2.087 -2.616,3.202 -2.616,3.202 0,0 1.02,-1.013 2.935,-2.914 0.958,-0.949 2.138,-2.123 3.523,-3.498 1.34,-1.42 2.605,-3.326 4.157,-5.356 0.724,-1.044 1.646,-2.067 2.33,-3.297 0.674,-1.237 1.382,-2.533 2.12,-3.882 0.695,-1.373 1.593,-2.732 2.214,-4.277 0.589,-1.56 1.202,-3.178 1.835,-4.848 1.484,-3.299 2.01,-7.092 3.03,-11.002 0.479,-1.964 0.519,-4.034 0.792,-6.131 0.191,-2.102 0.548,-4.262 0.449,-6.464 0.378,-8.851 -0.854,-18.356 -2.744,-28.232 -2.211,-9.794 -5.073,-20.001 -8.927,-30.193 -3.845,-10.183 -8.091,-20.601 -13.022,-30.854 -4.822,-10.314 -10.052,-20.598 -15.334,-30.834 -10.844,-20.243 -21.688,-40.486 -31.856,-59.466 -4.967,-9.52 -9.723,-18.73 -13.97,-27.587 m -213.677,-75.958 c -0.424,2.659 -0.986,6.558 -2.171,11.434 -0.96,4.908 -2.685,10.748 -4.706,17.399 -1.146,3.284 -2.364,6.779 -3.651,10.463 -1.417,3.635 -2.907,7.457 -4.461,11.446 -3.323,7.892 -7.09,16.367 -11.351,25.216 -4.248,8.857 -9.007,18.067 -13.972,27.587 -10.168,18.98 -21.012,39.223 -31.857,59.466 -5.283,10.236 -10.509,20.52 -15.332,30.834 -4.934,10.253 -9.174,20.671 -13.025,30.854 -3.852,10.192 -6.717,20.399 -8.923,30.193 -1.893,9.876 -3.125,19.381 -2.749,28.232 -0.094,2.202 0.26,4.362 0.451,6.464 0.275,2.097 0.31,4.167 0.792,6.131 1.019,3.91 1.548,7.703 3.03,11.002 0.633,1.67 1.246,3.288 1.836,4.848 0.62,1.545 1.517,2.904 2.216,4.277 0.736,1.349 1.444,2.645 2.118,3.882 0.684,1.23 1.606,2.253 2.332,3.297 1.553,2.03 2.813,3.936 4.155,5.356 1.386,1.375 2.567,2.549 3.524,3.498 1.914,1.901 2.935,2.914 2.935,2.914 0,0 -0.911,-1.115 -2.614,-3.202 -0.854,-1.045 -1.907,-2.334 -3.141,-3.846 -1.17,-1.566 -2.224,-3.533 -3.582,-5.598 -0.625,-1.069 -1.427,-2.096 -1.996,-3.342 -0.559,-1.251 -1.146,-2.559 -1.758,-3.923 -0.567,-1.375 -1.331,-2.732 -1.807,-4.265 -0.448,-1.539 -0.913,-3.137 -1.393,-4.784 -1.173,-3.227 -1.383,-6.929 -2.067,-10.677 -0.296,-1.885 -0.226,-3.88 -0.373,-5.878 -0.071,-2.01 -0.303,-4.052 -0.086,-6.163 0.117,-2.099 0.233,-4.241 0.354,-6.427 0.175,-2.177 0.602,-4.39 0.896,-6.637 0.489,-4.51 1.762,-9.094 2.72,-13.823 2.515,-9.381 5.747,-19.121 9.69,-29.018 7.959,-19.763 18.189,-40.225 28.881,-60.495 5.337,-10.161 10.677,-20.328 15.933,-30.329 5.31,-9.997 10.319,-19.963 15.117,-29.65 4.825,-9.67 9.199,-19.18 13.126,-28.302 3.994,-9.09 7.329,-17.888 10.215,-26.071 1.332,-4.131 2.61,-8.091 3.824,-11.857 1.006,-3.826 1.964,-7.459 2.862,-10.868 1.52,-6.895 2.791,-12.899 3.37,-17.932 0.86,-4.983 0.895,-8.975 1.07,-11.663 0.148,-2.693 0.226,-4.129 0.226,-4.129 0,0 -0.229,1.423 -0.658,4.086 m -146.979,345.901 c 35.178,59.866 135.319,48.581 137.985,27.923 0.564,-4.372 0.195,-8.816 -0.725,-13.112 l -23.018,-24.449 c -18.623,11.124 -64.349,32.881 -97.558,2.527 -22.011,-20.118 -25.1,-108.959 68.866,-249.908 0,0 -139.166,165.771 -85.55,257.019 m 174.896,43.117 c 9.691,-3.951 43.915,-17.165 67.946,-17.165 3.06,0 5.897,0.218 8.426,0.648 24.641,4.184 41.703,9.813 48.067,12.105 l 75.275,-89.802 -59.955,-23.984 c -9.324,4.09 -56.156,24.247 -73.688,24.247 -0.383,0 -0.749,-0.007 -1.104,-0.026 -9.846,-0.487 -29.382,-6.704 -48.275,-12.72 -14.726,-4.686 -29.952,-9.535 -34.621,-9.535 -5.981,0 -33.774,17.333 -58.606,34.944 z m 101.687,-186.177 1.046,62.321 11.917,-1.357 z m -82.896,60.759 11.863,1.768 3.566,-64.526 z m 123.945,3.406 c -16.789,-83.6 -38.53,-175.696 -45.731,-182.29 -18.115,-10.617 -61.007,-5.057 -66.095,1.58 -4.89,6.968 -34.029,109.48 -52.505,176.937 l 5.175,-1.306 c 5.968,-20.091 36.892,-123.598 43.354,-132.924 0.744,-1.074 1.84,-2.051 3.213,-2.936 1.158,1.624 2.366,3.19 3.538,4.794 0.408,0.523 0.842,1.018 1.256,1.534 2.559,3.199 5.215,6.286 7.955,9.273 4.557,4.913 11.54,9.527 17.211,13.96 l 0.008,-1.427 c -5.99,-5.213 -11.778,-10.664 -17.219,-16.533 -3.182,-3.469 -6.282,-7.036 -9.211,-10.806 -1.416,-1.939 -2.905,-3.795 -4.267,-5.802 -0.178,-0.259 -0.38,-0.561 -0.596,-0.892 -1.461,-2.231 -3.665,-5.9 -4.725,-7.795 2.358,0.822 5.955,4.302 8.153,5.308 2.215,0.994 4.302,2.135 6.457,3.196 0.668,0.352 1.309,0.74 1.971,1.103 10.898,-2.675 25.62,-3.294 36.484,-2.368 3.424,0.292 6.519,0.726 9.31,1.286 1.105,-0.926 2.201,-1.86 3.345,-2.75 1.808,-1.316 3.537,-2.7 5.412,-3.963 1.861,-1.273 3.747,-2.527 5.802,-3.646 -0.524,1.761 -1.161,3.43 -1.821,5.08 -0.18,0.452 -0.352,0.908 -0.537,1.356 -0.848,2.094 -1.843,4.073 -2.757,6.114 -1.938,3.996 -4.081,7.822 -6.325,11.568 -2.246,3.745 -4.667,7.35 -7.159,10.895 -2.015,2.846 -5.073,3.82 -7.229,6.557 l 0.341,55.113 1.785,-51.364 c -0.336,-0.707 3.088,-3.461 5.103,-6.307 2.492,-3.546 4.913,-7.148 7.159,-10.897 1.381,-2.303 2.7,-4.657 3.981,-7.044 0.8,-1.491 1.601,-2.984 2.344,-4.522 0.396,-0.887 0.809,-1.76 1.218,-2.637 3.152,1.697 5.334,3.788 6.494,6.282 17.369,37.301 35.987,131.312 36.772,135.294 l -1.768,0.846 4.104,0.138 c 0.063,0.308 0.063,0.303 0,-0.005 m -22.984,-145.65 c 3.271,13.038 6.629,27.324 9.88,41.695 8.838,1.971 17.526,4.382 26.039,7.24 -0.216,-12.503 -1.038,-26.53 -2.499,-39.558 -10.851,-3.925 -22.01,-7.047 -33.42,-9.377 m -16.451,-52.772 c 3.753,6.569 8.852,23.316 14.333,44.459 11.434,2.203 22.637,5.158 33.551,8.853 -0.283,-13.209 -1.306,-28.133 -3.107,-41.39 -14.432,-5.264 -29.402,-9.377 -44.777,-11.922 m 56.857,150.738 c -0.177,-12.514 -0.909,-26.463 -2.231,-39.647 -8.592,-3.079 -17.373,-5.695 -26.324,-7.841 3.237,14.516 6.319,28.856 9.045,41.807 6.595,1.664 13.104,3.549 19.51,5.681 m 2.465,8.93 c -6.582,-2.303 -13.325,-4.352 -20.2,-6.141 4.322,20.732 7.496,36.685 8.543,41.976 4.603,1.269 9.168,2.635 13.679,4.127 -0.143,-12.595 -0.805,-26.575 -2.022,-39.962 m -212.968,45.347 c 4.301,-1.586 10.633,-3.762 18.658,-6.103 0.581,-2.172 5.095,-19.088 11.389,-42.243 -10.661,2.999 -18.414,5.783 -22.521,7.358 -3.097,13.923 -5.667,28.295 -7.526,40.988 m 7.481,-49.545 c 5.385,-1.995 13.935,-4.903 25.031,-7.855 3.561,-13.055 7.545,-27.553 11.63,-42.228 -13.985,3.538 -24.142,7.158 -29.074,9.058 -3.16,13.823 -5.755,28.311 -7.587,41.025 m 7.481,-49.551 c 6.42,-2.387 17.337,-6.07 31.678,-9.489 4.064,-14.521 8.161,-28.958 11.979,-42.082 -17.501,3.863 -30.189,8.385 -35.948,10.628 -3.28,13.82 -5.931,28.488 -7.709,40.943 m 7.474,-49.551 c 7.442,-2.778 20.925,-7.208 38.754,-10.788 6.607,-22.401 12.079,-39.614 14.607,-44.525 -21.835,3.98 -37.963,9.923 -45.057,12.835 -3.603,13.924 -6.472,29.401 -8.304,42.478 m 96.697,-105.422 c -40.206,0 -71.265,10.776 -81.366,14.754 -3.452,13.062 -6.166,27.771 -7.862,40.177 13.424,-5.041 46.486,-16.475 89.113,-16.475 h 0.011 c 27.044,0 53.258,5.176 78.01,13.641 -0.326,-12.561 -1.393,-26.645 -3.228,-38.968 -23.684,-8.71 -48.795,-13.128 -74.678,-13.129 m 0.13,-50.065 h -0.008 c -35.537,0 -63.022,9.75 -73.193,13.926 -3.93,13.151 -6.943,29.263 -8.693,42.447 12.655,-4.778 42.784,-14.305 81.764,-14.305 25.364,0.002 50.03,4.099 73.413,12.184 -0.426,-13.306 -1.77,-28.649 -4.07,-41.117 -22.069,-8.187 -45.339,-13.135 -69.213,-13.135 m 0.156,-46.601 c -32.171,0 -56.831,8.4 -66.104,12.085 -3.929,12.24 -6.861,27.963 -8.491,40.665 11.859,-4.509 39.077,-13.781 74.431,-13.781 h 0.012 c 23.671,0 46.775,4.188 68.775,11.888 -0.525,-13.996 -2.137,-28.355 -4.563,-39.346 -20.546,-7.639 -42.078,-11.507 -64.06,-11.511 m 58.137,-37.922 c -18.725,-6.912 -38.195,-10.415 -57.942,-10.415 -27.285,-0.005 -48.326,6.769 -57.589,10.37 -4.72,10.946 -8.082,28.059 -9.754,41.673 11.029,-4.227 35.386,-12.047 67.14,-12.047 h 0.008 c 21.964,0 43.499,3.87 64.109,11.184 -0.697,-15.121 -2.842,-30.678 -5.972,-40.765 m -6.898,-49.796 c -16.574,-5.945 -33.633,-8.958 -50.81,-8.958 -21.279,0 -38.092,4.686 -47.403,8.038 -6.59,6.932 -10.938,27.433 -12.743,42.962 10.17,-3.927 31.715,-10.663 59.912,-10.659 20.235,0 40.18,3.503 59.389,10.425 -0.97,-16.947 -4.058,-34.517 -8.345,-41.808 m -219.021,454.561 c 0.043,-2.635 0.28,-5.357 0.552,-8.149 0.598,-5.582 1.625,-11.428 2.988,-17.426 1.276,-6.018 3.183,-12.115 5.053,-18.327 1.932,-6.199 4.176,-12.431 6.532,-18.629 2.332,-6.213 4.733,-12.413 7.256,-18.475 2.491,-6.084 4.945,-12.077 7.32,-17.873 4.77,-11.616 9.123,-22.561 12.341,-32.166 1.645,-4.784 3.009,-9.228 4.062,-13.214 1.124,-3.963 1.859,-7.494 2.413,-10.393 0.577,-2.901 0.849,-5.209 1.005,-6.786 0.175,-1.566 0.268,-2.4 0.268,-2.4 0,0 -0.24,0.806 -0.693,2.315 -0.408,1.518 -1.161,3.699 -2.118,6.459 -0.964,2.756 -2.23,6.065 -3.774,9.823 -1.521,3.76 -3.402,7.944 -5.435,12.51 -4.251,9.083 -9.209,19.678 -14.522,31.031 -2.61,5.719 -5.426,11.592 -7.989,17.708 -2.625,6.083 -5.165,12.34 -7.612,18.647 -4.658,12.698 -8.805,25.708 -10.989,38.372 -1.23,6.293 -1.811,12.513 -2.042,18.412 -0.241,5.904 0.085,11.518 0.832,16.627 0.254,2.561 0.911,4.977 1.352,7.273 0.542,2.284 1.288,4.398 1.863,6.396 1.415,3.93 2.86,7.258 4.353,9.865 1.294,2.698 2.752,4.491 3.604,5.823 0.889,1.304 1.359,1.997 1.359,1.997 0,0 -0.341,-0.766 -0.985,-2.208 -0.617,-1.439 -1.673,-3.536 -2.551,-6.297 -1.056,-2.681 -1.918,-6.102 -2.843,-9.988 -0.759,-3.939 -1.392,-8.395 -1.601,-13.292 -0.078,-2.45 -0.18,-4.991 0.001,-7.635 m 212.255,-500.057 c -11.181,-4.928 -26.873,-7.75 -43.055,-7.75 -17.431,0 -33.302,3.3 -41.417,8.605 -6.728,4.401 -10.78,22.988 -12.307,37.133 9.272,-3.621 28.051,-9.455 52.735,-9.455 18.487,0 36.827,3.302 54.614,9.824 -1.277,-17.727 -5.327,-36.049 -10.57,-38.357 m 116.665,507.692 c -0.211,4.897 -0.845,9.353 -1.603,13.292 -0.926,3.886 -1.789,7.307 -2.842,9.988 -0.878,2.761 -1.936,4.858 -2.552,6.297 -0.642,1.442 -0.985,2.208 -0.985,2.208 0,0 0.471,-0.693 1.358,-1.997 0.85,-1.332 2.308,-3.125 3.604,-5.823 1.496,-2.607 2.938,-5.935 4.355,-9.865 0.574,-1.998 1.32,-4.112 1.862,-6.396 0.44,-2.296 1.097,-4.712 1.352,-7.273 0.75,-5.109 1.072,-10.723 0.831,-16.627 -0.232,-5.899 -0.813,-12.119 -2.039,-18.412 -2.187,-12.664 -6.332,-25.674 -10.987,-38.372 -2.449,-6.307 -4.99,-12.564 -7.62,-18.647 -2.557,-6.116 -5.376,-11.989 -7.984,-17.708 -5.315,-11.353 -10.274,-21.948 -14.523,-31.031 -2.035,-4.566 -3.917,-8.75 -5.435,-12.51 -1.546,-3.758 -2.812,-7.067 -3.777,-9.823 -0.957,-2.76 -1.711,-4.941 -2.116,-6.459 -0.453,-1.509 -0.694,-2.315 -0.694,-2.315 0,0 0.093,0.834 0.268,2.4 0.154,1.577 0.426,3.885 1.004,6.786 0.556,2.899 1.293,6.43 2.414,10.393 1.049,3.986 2.416,8.43 4.064,13.214 3.219,9.605 7.572,20.55 12.34,32.166 2.375,5.796 4.831,11.789 7.321,17.873 2.523,6.062 4.924,12.262 7.255,18.475 2.355,6.198 4.6,12.43 6.533,18.629 1.87,6.21 3.779,12.309 5.053,18.326 1.363,5.999 2.39,11.845 2.991,17.427 0.27,2.792 0.508,5.514 0.552,8.149 0.178,2.644 0.077,5.185 0,7.635 m 49.419,96.429 c -53.092,26.886 -108.748,8.091 -131.987,-2.235 l -16.702,-2.235 -4.053,4.833 c 0,0 -13.387,-5.314 -31.227,-9.558 l -33.413,-4.471 c -25.878,2.118 -61.311,17.178 -61.693,17.34 l -2.57,1.102 -7.905,-8.398 -8.044,1.197 c -19.125,9.438 -76.247,32.334 -132.251,2.425 -81.209,-43.371 -51.872,-158.942 -24.991,-207.925 46.73,-85.153 181.933,-239.912 157.943,-382.86 0,0 5.859,-5.377 13.605,-11.017 l 0.051,-0.511 0.695,-0.028 c 1.113,-0.802 2.262,-1.604 3.436,-2.394 l -0.022,-0.035 c 0.06,-0.039 0.573,-0.375 1.459,-0.919 4.377,-2.857 9.013,-5.468 13.358,-7.11 13.491,-6.337 34.874,-14.114 58.569,-14.114 16.248,0 33.575,3.665 50.188,13.946 14.102,2.709 31.047,20.667 31.047,20.667 -27.091,142.394 104.717,300.05 149.588,386.201 25.809,49.554 57.049,164.503 -25.081,206.099"
           style="fill:#000000;fill-opacity:1;fill-rule:nonzero;stroke:none"
           id="path871"
           inkscape:connector-curvature="0" /></g></marker></defs><sodipodi:namedview
     pagecolor="#ffffff"
     bordercolor="#666666"
     borderopacity="1"
     objecttolerance="10"
     gridtolerance="10"
     guidetolerance="10"
     inkscape:pageopacity="0"
     inkscape:pageshadow="2"
     inkscape:window-width="1920"
     inkscape:window-height="1017"
     id="namedview3159"
     showgrid="false"
     inkscape:zoom="1.0289025"
     inkscape:cx="61.230291"
     inkscape:cy="310.0391"
     inkscape:window-x="-8"
     inkscape:window-y="-8"
     inkscape:window-maximized="1"
     inkscape:current-layer="g3165"
     inkscape:showpageshadow="2"
     inkscape:pagecheckerboard="0"
     inkscape:deskcolor="#d1d1d1" /><g
     id="g3165"
     inkscape:groupmode="layer"
     inkscape:label="cobra-snake--publicdomainvectors.org"
     transform="matrix(1.3333333,0,0,-1.3333333,63.649873,933.80623)"><g
       id="g3226"
       transform="translate(32.968481,-4.4893843)"><path
         id="path1009-3"
         style="fill:#ffffff;fill-opacity:1;stroke-width:0.346242"
         d="m 263.9707,253.36523 c -3.61743,0.25258 -7.33085,0.30438 -10.80136,1.45286 -1.75275,0.78434 -3.01958,2.51894 -3.30215,4.41043 -5.42823,-1.29992 -11.10822,-0.64426 -16.46065,0.69869 -10.07788,2.45065 -19.49977,7.00461 -28.48662,12.09232 -10.55806,6.06363 -20.52789,13.13508 -29.87068,20.93576 -1.78859,1.49927 -3.67733,3.39468 -3.75432,5.87869 -0.009,1.14087 0.43165,2.26214 1.16602,3.12891 -6.71988,2.63811 -13.16823,5.90477 -19.54492,9.27539 1.08319,-2.81432 -0.26288,-6.53416 -3.25586,-7.48242 -3.61647,-1.18215 -7.39225,-1.63764 -11.09154,-2.39829 -5.04934,-0.75857 -10.13984,-1.2003 -15.21315,-1.76968 -6.25932,-0.63953 -12.52192,-1.4251 -18.82459,-1.39571 -17.132134,-0.20971 -34.404579,1.79529 -50.730727,7.13498 -15.807273,5.17489 -30.763227,13.50659 -42.621188,25.26794 -3.4079172,3.44601 -6.8940758,7.10554 -8.4973244,11.78576 -0.2609678,0.77846 -0.4821042,1.57102 -0.6308594,2.37891 -2.83934526,-0.99622 -5.9400646,0.22729 -8.1328124,2.08789 -3.6987547,2.98056 -6.2610868,7.07508 -8.6718748,11.10351 -3.47018,6.07631 -6.207761,12.61955 -7.704943,19.46775 -1.093028,5.35061 -1.611535,10.90238 -0.786125,16.32773 1.011832,6.2373 4.087456,12.36742 9.314103,16.09737 6.1546271,4.56004 13.72796824,6.62368 21.1837157,7.84241 15.2104943,2.51615 30.7677313,1.69169 45.9709193,-0.4426 16.719073,-2.40988 33.21132,-6.60909 48.904336,-12.88686 11.79696,-4.7975 23.06289,-10.82153 33.89143,-17.50541 -12.56663,10.85194 -24.72847,22.16994 -37.510409,32.77399 -17.777391,14.64741 -34.95728,30.07607 -50.735903,46.87598 -7.555733,8.10538 -14.922023,16.41446 -21.582477,25.27921 -3.304982,4.30913 -6.225189,8.8927 -8.989392,13.56231 -7.040282,11.72099 -13.3525477,24.03642 -17.04224357,37.25691 -3.13544093,11.2711 -5.08143673,22.91704 -5.20042743,34.63207 -0.177448,11.46403 1.3537868,22.89768 3.8518689,34.06875 0.52680463,2.32939 1.0976597,4.65355 2.03274622,6.85847 2.09612268,5.3465 4.63426798,10.51604 7.41395018,15.53761 1.8980787,3.34521 4.4620427,6.24315 7.2124927,8.90856 3.722415,3.64009 7.776898,7.08644 12.565404,9.23587 3.834465,1.78328 7.78989,3.29069 11.721741,4.8425 4.142452,1.61142 8.404149,2.94066 12.427635,4.84261 2.597242,1.26344 4.763193,3.21212 7.162419,4.79177 11.526543,8.13903 22.847852,16.73566 35.52732,23.04248 6.930545,3.38328 14.380745,5.67337 22.005415,6.82387 10.81878,1.76705 22.13798,1.73031 32.65549,-1.62788 5.74511,-1.92062 11.17851,-4.63687 16.63434,-7.24087 3.83297,-1.8708 7.53716,-3.99317 11.19116,-6.18613 3.06796,-1.46356 5.948,-3.26921 8.79276,-5.12041 5.22512,-3.35064 10.34054,-7.00324 16.178,-9.23552 5.81893,-2.38081 12.00437,-4.15391 17.2399,-7.7795 2.40046,-1.65369 4.51958,-3.87804 5.46557,-6.68698 1.41746,-4.27226 1.62326,-8.80615 2.34397,-13.20762 -3.75951,-5.44358 -7.52391,-10.88379 -11.28516,-16.32617 -5.9132,0.27971 -11.83073,0.64491 -17.6855,1.55556 -10.06253,1.32591 -20.11919,2.74366 -30.09119,4.63872 -2.5589,0.35531 -5.16736,0.50326 -7.74335,0.28767 -2.64794,-0.2563 -4.74305,-2.59058 -5.08467,-5.1716 -0.38039,-3.21885 -0.84129,-6.4306 -1.25661,-9.64629 -8.40578,5.17501 -17.0441,10.08972 -24.58989,16.50958 -8.71466,7.20591 -16.39994,15.75735 -22.07679,25.56629 -0.62102,0.88443 -1.16562,1.86722 -2.04622,2.52569 -2.23608,-0.5742 -4.28946,-1.3797 -6.489622,-2.14778 -5.04343,-1.88894 -10.075631,-3.88023 -14.801389,-6.48112 -1.662122,-0.92616 -3.464752,-2.02148 -5.118561,-3.11276 -9.812176,-6.46611 -18.090967,-15.11828 -24.586517,-24.88138 -2.118173,-3.1842 -4.138233,-6.64285 -5.90625,-10.10938 -4.401429,-8.63035 -7.626465,-17.87656 -9.638965,-27.44655 -0.561055,-2.63728 -1.026108,-5.38321 -1.388379,-8.03587 -1.068599,-7.7777 -1.55496,-15.6967 -0.526267,-23.50704 0.970006,-7.45829 2.436374,-14.84381 4.00814,-22.1954 0.591709,-2.64518 1.279796,-5.29542 2.072814,-7.81319 0.264547,-0.82818 0.635833,-1.92286 0.975036,-2.8415 2.688549,-6.9024 5.997354,-13.5516 9.570743,-20.03484 1.950159,-3.48527 4.067566,-6.87511 6.288206,-10.19397 0.555411,-0.81006 1.233757,-1.8196 1.817588,-2.63605 7.365086,-10.53805 15.998219,-20.11293 24.990245,-29.27562 3.282584,-3.38229 6.569832,-6.76316 9.698546,-10.28743 0.908571,-0.94857 1.87532,-1.83839 2.827605,-2.7423 -1.904111,2.4787 -4.078676,4.72277 -6.175817,7.03356 -3.410806,3.81323 -6.420469,7.96523 -9.85348,11.75745 -0.993711,1.0755 -1.933761,2.31377 -2.064453,3.82617 0.150405,0.7376 -0.75802,0.37717 -1.19731,0.64965 -1.889596,0.56495 -2.897643,2.37417 -3.916489,3.90757 -4.270116,6.15565 -8.902284,12.05997 -12.909872,18.39688 -11.118763,17.3226 -19.122405,36.92323 -21.48848,57.46374 -1.112336,9.86989 -0.619961,19.91106 1.429822,29.62825 1.307003,7.02806 3.256216,13.97572 6.358275,20.43608 1.166275,2.77581 2.115574,5.66632 3.744238,8.22271 2.492435,4.24041 5.333904,8.26548 8.212922,12.2492 3.76619,4.95694 8.10473,9.45784 12.660002,13.69064 2.353897,2.13114 5.106577,3.74106 7.604721,5.68886 5.430398,3.98486 10.830014,8.09798 16.839113,11.1861 1.909305,0.82609 4.299535,0.39204 5.702975,-1.17487 3.20141,-2.88682 6.02545,-6.15881 9.13914,-9.1378 2.93944,-2.88959 5.87687,-5.59571 9.023,-8.23675 5.4754,-4.50667 11.05546,-8.98042 17.3046,-12.37957 3.90495,-1.93418 7.92891,-3.6195 11.79653,-5.63216 2.4529,-1.22172 4.92705,-2.45256 7.6119,-3.07982 5.1053,-1.47525 10.03363,-3.45731 15.26237,-4.51862 3.41618,-0.81164 6.83648,-1.6273 10.32229,-2.08178 2.31368,-0.3439 4.56701,-1.34228 6.94476,-1.016 2.67541,0.18313 5.57138,-0.55502 7.37206,-2.6569 1.69451,-1.81975 2.08958,-4.5655 1.28607,-6.87695 -1.0159,-3.40874 -3.88821,-5.83412 -6.85371,-7.57242 -2.04376,-1.33915 -4.31451,-2.86479 -6.88565,-2.49979 -2.46945,0.30225 -4.73181,1.42848 -7.06194,2.23077 -5.98463,2.26569 -11.80698,4.96421 -17.88916,6.966 -3.36293,0.90658 -6.77228,1.64917 -10.19667,2.28315 -4.78535,0.75829 -9.52823,1.76852 -14.33843,2.37295 -3.30018,0.44814 -6.48489,0.80417 -9.81833,0.90704 -6.42522,0.27614 -12.95047,0.37441 -19.42398,0.32212 4.68694,-0.24026 9.35561,-0.72948 14.01392,-1.28156 3.83709,-0.29629 7.68497,-0.41943 11.52709,-0.63445 -1.97551,-3.62129 -4.34438,-7.08976 -5.5556,-11.07017 -1.05645,-2.81623 -2.19259,-5.64479 -2.53193,-8.65762 -0.54178,-3.17055 -1.50422,-6.4387 -1.91051,-9.52026 -0.79072,-6.2055 -1.07281,-12.49529 -0.46289,-18.73047 0.12139,-1.35437 0.28692,-2.94157 0.46526,-4.38163 0.21953,-2.12279 0.63679,-4.22882 0.80817,-6.35196 0.0299,-0.47123 -0.18672,-0.97857 -0.19921,-1.39922 0.73753,-0.74378 0.64438,-1.88445 1.04796,-2.79873 2.41025,-8.0827 4.35167,-16.39824 8.27453,-23.92909 1.0039,-2.30744 2.70016,-4.3517 3.09938,-6.88937 -0.14757,-0.60846 0.64041,-0.51379 0.95313,-0.86523 1.12765,-0.7124 1.30734,-2.1161 1.98239,-3.16717 2.35339,-4.54583 4.49844,-9.22384 7.28606,-13.526 1.18242,-1.47061 2.21881,-3.04692 3.18916,-4.66075 3.13298,-4.58137 6.39997,-9.06953 9.69278,-13.53671 3.6906,-4.89461 7.67126,-9.7635 11.57202,-14.57001 4.48762,-5.54444 9.23008,-10.88088 13.67212,-16.46124 1.21321,-1.01094 2.69474,-1.70471 3.68757,-2.97288 1.53913,-1.71512 2.09446,-4.3658 1.18743,-6.46266 2.22306,0.346 4.2918,-0.99958 5.65038,-2.64885 2.13441,-2.02643 4.50395,-3.78512 6.70208,-5.74093 12.65409,-10.68498 25.11208,-21.53063 38.75767,-30.96719 14.47757,-10.30466 28.82151,-21.07256 40.79601,-34.29517 9.62103,-10.68844 17.54487,-23.04937 22.3787,-36.63419 1.77509,-5.36116 2.37807,-11.02238 2.79428,-16.62777 0.3517,-4.79552 0.12414,-9.64332 -0.90479,-14.34793 -1.44781,-6.91706 -4.3822,-13.6339 -9.16014,-18.90705 -5.95387,-6.73422 -14.65079,-10.81059 -23.56862,-11.55322 -3.03193,-0.35199 -6.07329,-0.68796 -9.12917,-0.69763 z m -54.65039,41.30665 c 2.33621,0.062 4.99488,0.22243 6.67997,2.07344 0.69402,0.95892 1.59953,1.88285 1.87049,3.05973 -0.0665,6.75348 -3.08973,13.12911 -7.1395,18.40209 -2.5488,3.37733 -5.48896,6.43485 -8.49689,9.40224 2.35122,-3.55525 4.5271,-7.30053 5.806,-11.38646 0.73316,-2.75123 1.0328,-5.63769 0.8229,-8.47683 -0.67082,-4.58851 -4.46803,-8.32051 -8.88524,-9.45779 -1.63476,-0.50298 -3.32669,-0.80203 -5.02687,-0.97385 4.21617,-1.2433 8.52057,-2.36488 12.9267,-2.61402 0.4804,-0.0286 0.96143,-0.0253 1.44244,-0.0285 z M 78.716797,339.83984 c 4.682446,0.06 9.579659,0.25181 13.820833,2.46632 0.329038,0.22699 1.097215,0.42225 1.237761,0.58056 -5.657442,2.40083 -11.387848,4.62928 -17.183594,6.67383 0.06822,-2.5079 -1.8064,-4.62494 -3.999464,-5.59754 -2.955871,-1.38563 -6.338925,-1.10767 -9.474725,-1.4114 -1.331698,-0.0905 -2.663697,-0.2028 -3.982842,-0.41099 6.303421,-1.56949 13.012009,-2.25683 19.582031,-2.30078 z m 32.289063,94.81641 c -0.15855,0.37294 0.47849,1.32505 -0.11914,1.16992 -0.48724,-0.0404 -0.97866,-0.0309 -1.46289,0.0391 0.52929,-0.48828 1.05859,-0.97656 1.58789,-1.46484 -0.002,0.0853 -0.004,0.17057 -0.006,0.25586 z" /><g
         id="g3144"><path
           style="fill:#264e97;fill-opacity:1;stroke-width:0.346242"
           d="m 109.68941,302.80013 c -13.380289,-0.38517 -22.863524,0.14677 -34.095258,1.91249 -26.134532,4.10856 -48.873836,15.4376 -63.916907,31.84431 -4.0157744,4.37979 -5.6886376,8.10332 -5.3456252,11.89847 0.1649574,1.8251 1.6436821,4.27975 3.4378819,5.70682 5.3326963,4.2415 13.4290053,5.39922 26.4752703,3.7858 9.79663,-1.21155 26.468571,-4.39545 32.111526,-6.13247 4.025905,-1.23925 4.796665,-2.4664 2.365686,-3.76645 -0.981036,-0.52464 -2.153953,-0.69026 -6.439583,-0.90928 -5.897082,-0.30138 -9.883107,-1.09838 -12.035097,-2.40639 -1.628265,-0.98968 -2.266395,-2.48867 -1.530609,-3.59545 2.115495,-3.18218 17.529019,-6.13513 30.120718,-5.77057 5.491078,0.15899 9.580703,0.93653 12.589273,2.39367 2.306488,1.11707 2.570976,1.17275 4.692878,0.98787 6.247636,-0.54433 14.371086,-4.54914 32.809526,-16.17491 5.7,-3.59394 11.50127,-7.24508 12.89172,-8.11361 3.94513,-2.4643 5.83595,-5.08987 4.57694,-6.35552 -0.21876,-0.21992 -2.3195,-0.75758 -4.6683,-1.19478 -2.3488,-0.43722 -4.88382,-0.92888 -5.63338,-1.0926 -1.74417,-0.38096 -25.87946,-2.94465 -28.40666,-3.0174 z"
           id="path1009" /><path
           style="fill:#264e97;fill-opacity:1;stroke-width:0.346242"
           d="m 191.8872,301.62491 c -13.07023,1.24301 -26.06309,6.93216 -58.14555,25.46001 -12.70174,7.33535 -21.85767,12.38187 -26.73923,14.73798 -24.935194,12.03512 -53.557282,20.90931 -72.798679,22.57101 -15.929571,1.37568 -25.7038261,-0.9274 -30.3070191,-7.14118 -1.4606597,-1.97174 -1.9862857,-3.30832 -2.1966676,-5.58581 -0.2169042,-2.34811 -0.6714699,-2.91446 -2.19101628,-2.72985 -4.68269482,0.5689 -13.06809702,13.61331 -16.75162002,26.05897 -1.60566,5.42512 -2.331538,12.91041 -1.681589,17.34053 0.891848,6.07886 3.566416,10.95069 7.616774,13.8743 5.5523553,4.00777 12.01671202,6.12544 23.253973,7.61782 26.058079,3.46069 65.168527,-3.12899 93.504404,-15.75444 21.08154,-9.39318 43.14067,-23.55281 61.19078,-39.27801 19.37803,-16.88211 31.1358,-30.30282 36.11124,-41.21856 0.98175,-2.1539 1.27928,-3.29535 1.54806,-5.93886 0.28882,-2.83932 0.24211,-3.47271 -0.35191,-4.78526 -1.26499,-2.79501 -3.79076,-4.29729 -8.25519,-4.91005 -1.61107,-0.22113 -3.32412,-0.3645 -3.80676,-0.31861 z"
           id="path1007" /><path
           id="path1001"
           style="fill:#264e97;fill-opacity:1;stroke-width:0.346242"
           d="m 129.05752,692.83858 c -4.11691,-0.0894 -8.43065,-0.54015 -12.98584,-1.34912 -14.32727,-2.54445 -24.346193,-7.57509 -46.249513,-23.22364 -5.967606,-4.26347 -11.98304,-8.54758 -13.368164,-9.52002 -1.385125,-0.97243 -5.312766,-2.73302 -8.727539,-3.9126 -3.41477,-1.17958 -9.588831,-3.55921 -13.719727,-5.28808 -6.671001,-2.79197 -8.093351,-3.64831 -12.722169,-7.6582 -3.056303,-2.64764 -6.321256,-6.14137 -7.895508,-8.44776 -2.863961,-4.19589 -8.6974897,-16.66748 -9.6093748,-20.54443 -6.079803,-25.8486 -5.8041015,-45.95775 0.9609375,-70.03418 2.898399,-10.31524 8.8815383,-23.11475 16.9379883,-36.23438 5.119868,-8.33751 4.958919,-8.10816 12.552247,-17.91065 20.2109,-24.57523 41.384453,-44.12835 64.18799,-63.19775 16.897722,-13.71649 33.419422,-29.59284 48.496582,-42.02051 15.07716,-12.42766 5.73736,-4.12416 20.33496,-16.84277 0.0552,-3.4e-4 0.13218,0.0221 0.19043,0.0249 9.60903,-9.07588 18.80362,-16.7789 33.98291,-32.01123 8.17777,-7.99291 21.35558,-19.5142 20.94287,-35.98682 -0.91225,-2.55479 -3.16275,-5.52618 -5.0581,-6.67822 -5.93796,-3.60918 -17.6745,-1.91633 -34.93213,5.0376 -3.04908,1.22862 -5.78214,2.21041 -6.07324,2.18261 -1.27332,-0.12173 -0.12716,-1.49601 4.02832,-4.83252 22.2041,-17.82806 44.61833,-29.44109 60.27539,-31.229 3.00553,-0.34321 6.82136,-0.0541 9.21973,0.69873 7.66467,2.40605 10.34353,9.86051 7.49267,20.84766 -3.48649,13.43675 -15.45728,32.49679 -31.5293,50.20166 -5.15487,5.67857 -8.8848,9.33911 -17.2749,16.95556 -9.19687,8.34888 -17.2148,15.96022 -24.71484,23.45508 0.88708,0.57756 1.8035,1.18514 2.71289,1.78565 21.74548,-20.4258 49.08965,-46.84182 55.07227,-54.98291 8.37343,-11.39445 15.55558,-24.49693 19.00341,-34.66846 4.0078,-11.82322 2.17372,-22.56941 -4.37841,-25.65235 -1.94946,-0.91728 -2.42546,-1.90057 -1.34913,-2.78906 0.51469,-0.42488 4.81119,-0.95774 9.29883,-1.15283 1.10244,-0.0478 4.5585,0.21076 7.68018,0.57422 4.72533,0.55016 6.23932,0.86486 9.03808,1.87939 12.52296,4.53953 20.02312,15.43732 21.42481,31.1294 0.46673,5.2255 -0.71392,16.63223 -2.21045,21.35302 -2.30943,7.28491 -6.93856,16.43887 -12.15674,24.03809 -12.30638,17.92171 -29.2713,31.5559 -53.15478,48.31641 -13.47512,9.45631 -31.85262,25.72551 -41.51368,33.72363 -0.0779,-0.0345 -0.13234,-0.0624 -0.20947,-0.0967 -1.04297,1.40081 -2.17479,2.54697 -2.60156,2.55762 -0.46067,0.0114 -3.82276,-2.26676 -7.47071,-5.0625 -3.64795,-2.79574 -8.56804,-6.31529 -10.93359,-7.8208 -2.36557,-1.50554 -7.01404,-4.74324 -10.33008,-7.19531 -6.10651,-4.51553 -11.23243,-7.46192 -12.97851,-7.46192 -0.52666,0 -4.37985,3.2932 -8.56348,7.31983 -4.18362,4.02662 -13.2572,12.51557 -20.16358,18.86425 -20.664528,18.9959 -27.774324,25.65469 -27.774899,26.01417 -4.34e-4,0.18749 -4.41431,4.84818 -9.808594,10.35644 -17.128851,17.49076 -28.123959,32.26706 -36.388184,48.90088 -6.168931,12.41652 -7.914238,17.3853 -10.31543,29.37012 -3.837396,19.15322 -4.374524,25.47752 -3.202148,37.75195 3.535478,37.01541 23.673065,69.09407 52.41797,83.50342 5.814359,2.91464 18.850755,7.7959 20.822755,7.7959 1.90648,0 4.05021,-2.00567 6.33252,-5.92383 7.10387,-12.19564 19.21305,-23.97488 33.93018,-33.00732 l 4.65087,-2.85498 0.36329,2.73633 c 0.46387,3.49677 2.3305,6.25388 5.37304,7.93359 1.95629,1.07999 3.23606,1.32119 6.86866,1.29199 2.45528,-0.0198 5.49846,-0.29211 6.76171,-0.60498 4.58309,-1.13502 32.86848,-5.22198 38.25293,-5.52685 l 5.52247,-0.31202 4.42675,6.40284 4.42676,6.40136 -0.70605,5.17383 c -0.46382,3.39402 -1.1277,5.80001 -1.93067,6.99463 -1.85968,2.7667 -6.12475,5.2475 -14.01123,8.15186 -9.06988,3.34015 -11.36523,4.51608 -20.32617,10.41211 -4.02187,2.64624 -7.96843,5.06096 -8.77002,5.36572 -0.80156,0.30476 -2.82199,1.4263 -4.48975,2.49316 -4.87506,3.11854 -19.22578,9.91436 -24.22851,11.47266 -5.97929,1.8625 -12.29572,2.71541 -19.15723,2.56641 z m 34.58496,-23.03614 c 0.1801,0.1801 1.6722,-0.63807 3.31641,-1.81933 5.41244,-3.88845 16.28154,-9.7822 24.82764,-13.46338 4.62382,-1.99169 8.40673,-3.8189 8.40673,-4.05908 0,-0.24016 -0.58141,-0.59795 -1.29199,-0.79541 -0.71058,-0.19745 -3.61764,-0.48698 -6.45996,-0.64307 -7.93616,-0.43581 -12.15543,1.35125 -19.29346,8.1709 -4.35768,4.16329 -10.20051,11.91423 -9.50537,12.60937 z" /><path
           id="path2334"
           style="fill:#9c9ea0;fill-opacity:1;stroke:none;stroke-width:0.203013"
           d="m 100.61122,645.36286 c -0.0547,0.002 -0.0995,-0.0134 -0.15001,-0.0323 -1.963738,-0.73486 -8.883094,-5.2901 -14.601592,-9.61324 -2.560469,-1.93568 -5.432053,-4.01832 -6.381142,-4.62718 -1.304044,-0.83658 -2.769393,-2.15414 -5.996877,-5.39338 -5.316453,-5.33584 -7.764384,-8.32591 -12.321459,-15.04586 -4.02347,-5.93307 -5.564464,-8.66888 -6.534609,-11.60835 -0.301546,-0.91367 -1.032889,-2.61666 -1.625858,-3.78367 -1.166253,-2.2953 -3.169641,-8.10356 -4.143702,-12.01453 -0.758851,-3.04689 -2.156955,-10.40924 -2.563989,-13.50077 -0.169058,-1.28405 -0.416551,-4.19908 -0.550416,-6.47807 -0.85375,-14.53485 2.522389,-31.55863 9.494382,-47.87002 4.873406,-11.40162 10.805389,-21.54805 19.254175,-32.93495 1.703371,-2.29572 3.86474,-5.30555 4.803731,-6.68922 0.938982,-1.38367 1.794173,-2.63456 1.900494,-2.77862 0.142202,-0.19268 0.261907,-0.0642 0.453485,0.4858 0.143234,0.41116 0.262481,0.77445 0.264254,0.80659 0.0087,0.16714 9.204872,6.09431 11.497565,7.41041 5.82292,3.34259 27.559418,14.56216 32.061448,16.54941 0.99964,0.44126 2.81687,1.36033 4.03869,2.04127 1.22181,0.68094 2.30829,1.26713 2.41513,1.30276 0.10685,0.0356 -0.38368,1.11011 -1.09045,2.3886 -3.69451,6.68306 -5.74694,12.08187 -8.83549,23.23516 -0.74208,2.67976 -1.3807,4.90505 -1.41816,4.94452 -0.1909,0.20088 -8.36797,-2.79962 -12.27416,-4.50372 -1.39572,-0.60889 -5.23237,-2.03684 -8.526256,-3.1721 -7.599268,-2.61916 -8.725622,-3.02096 -16.241309,-5.79611 -7.541755,-2.78475 -10.994036,-3.94302 -14.487359,-4.86142 -6.790946,-1.78536 -9.265913,-1.72536 -9.265913,0.22385 0,1.47124 2.236755,3.10211 9.03513,6.59114 2.121486,1.08879 4.734938,2.29665 5.807638,2.68401 1.072693,0.38736 3.356186,1.27111 5.074902,1.96395 7.83228,3.15737 27.763567,9.13922 36.215507,10.8687 1.89819,0.38842 3.55145,0.74278 3.67407,0.78697 0.15945,0.0575 0.14911,0.4467 -0.0381,1.36738 -0.36179,1.77941 -1.0308,7.72197 -1.32123,11.7422 -0.27377,3.78974 -0.15573,8.84868 0.31617,13.60116 0.416,4.18929 0.61301,5.37629 1.56125,9.40554 0.44221,1.87909 0.89016,4.17737 0.99582,5.10722 0.11174,0.98336 0.48157,2.48424 0.8839,3.58751 0.38044,1.04321 1.18811,3.27688 1.79434,4.96412 0.60622,1.68725 1.33169,3.4783 1.612,3.97984 l 0.50888,0.91159 -2.55707,0.1304 c -1.40657,0.0718 -3.47138,0.27192 -4.58795,0.44425 -4.70226,0.72571 -17.7873,1.45697 -22.027015,1.23122 -1.284059,-0.0684 -3.567543,-0.0367 -5.074909,0.0705 -4.956985,0.3524 -14.525729,-0.40196 -27.063839,-2.13474 -6.019201,-0.83186 -8.25832,-0.90027 -8.886281,-0.27232 -0.533006,0.53301 -0.387763,1.32281 0.356562,1.93857 0.502316,0.41556 5.236016,2.34726 8.409707,3.43173 8.432355,2.88138 27.335687,5.41711 42.511255,5.70148 7.51206,0.14075 21.75385,-0.21011 25.57992,-0.63003 4.87554,-0.53512 11.42206,-1.5105 15.06778,-2.24436 1.92449,-0.38739 3.75998,-0.70389 4.07908,-0.70389 0.71526,0 9.011,-1.84235 11.50796,-2.55591 1.0049,-0.28718 3.51697,-1.21204 5.58262,-2.05512 14.64373,-5.97672 17.28954,-6.9604 18.72222,-6.9604 0.3136,0 1.04831,0.3061 1.63279,0.68081 0.58447,0.37472 1.74848,1.09861 2.58591,1.60855 2.81625,1.71493 4.46564,3.83678 4.46564,5.74302 0,0.79405 -0.10425,1.04468 -0.67158,1.61202 -0.91663,0.91663 -1.98234,1.1677 -4.2637,1.00275 -1.7027,-0.12311 -2.13153,-0.0712 -4.92836,0.59773 -1.68485,0.40291 -3.41853,0.73272 -3.85176,0.73272 -0.77461,0 -4.8553,0.87551 -11.45835,2.45899 -1.84233,0.44182 -4.94755,1.35638 -6.90154,2.03204 -3.7681,1.30295 -5.91592,1.9661 -8.21239,2.53515 -0.89712,0.2223 -3.41334,1.34573 -6.90269,3.0821 -3.01992,1.50276 -6.62295,3.22293 -8.007,3.8229 -3.33719,1.44665 -5.44763,2.6136 -8.75126,4.83836 -7.96197,5.36182 -16.79786,12.76279 -23.75212,19.89573 -6.64828,6.81913 -7.51503,7.7059 -7.89853,7.71967 z m 34.38195,-148.74152 -0.90813,-0.66812 c -1.91128,-1.40349 -21.96378,-13.03082 -30.44826,-17.656 -2.62395,-1.43039 -5.77487,-3.15181 -7.003094,-3.82407 -1.228232,-0.67225 -4.116855,-2.34946 -6.419214,-3.72829 -2.30235,-1.37882 -4.297027,-2.50744 -4.432171,-2.50744 -0.135135,0 0.206135,-0.48001 0.759269,-1.06621 1.501615,-1.59137 4.164994,-4.7775 6.626916,-7.92969 1.204387,-1.54207 3.467075,-4.13981 5.028747,-5.77301 1.561681,-1.63322 3.788197,-4.21903 4.947977,-5.74649 1.15978,-1.52745 2.40682,-3.00504 2.77169,-3.28402 0.36488,-0.27901 1.34924,-1.29929 2.18667,-2.26629 0.83743,-0.96701 1.72034,-1.80921 1.96165,-1.87165 0.2413,-0.0625 0.83445,0.0627 1.31892,0.2781 1.28281,0.57026 27.5787,16.22794 30.92714,18.41528 1.56319,1.02113 3.57238,2.51868 4.46564,3.32903 0.89324,0.81035 1.899,1.62036 2.23397,1.79894 0.86889,0.46327 2.15141,0.41638 2.88363,-0.105 1.37875,-0.98176 3.51135,-4.42933 3.51135,-5.67725 0,-0.54831 -0.16022,-0.8522 -0.71889,-1.36392 -0.93007,-0.85191 -4.947,-3.2309 -9.43207,-5.58724 -1.954,-1.02657 -4.42034,-2.48742 -5.48108,-3.24595 -1.06074,-0.75855 -3.1168,-2.05803 -4.56834,-2.88824 -1.45154,-0.83021 -4.53897,-2.62833 -6.86116,-3.99485 -4.2897,-2.52431 -8.63547,-4.77926 -11.20679,-5.81571 -0.7816,-0.31505 -1.49343,-0.63326 -1.58201,-0.70735 -0.37619,-0.31468 2.2317,-3.31904 5.72341,-6.59345 0.71438,-0.66994 3.10091,-3.18199 5.30337,-5.58263 2.20245,-2.40062 5.2237,-5.55271 6.71461,-7.00424 4.57916,-4.45822 4.94042,-4.83364 5.86302,-6.09034 1.12186,-1.52813 5.12843,-5.66248 7.00886,-7.23272 0.7816,-0.65267 1.4488,-1.18791 1.48278,-1.18968 0.034,-0.002 0.67287,0.52431 1.42046,1.16776 1.94836,1.67688 6.26602,4.87124 10.49484,7.76582 2.00982,1.37569 5.37869,3.729 7.48657,5.22837 6.82757,4.85659 10.73408,7.31268 12.50264,7.86276 0.27483,0.0855 0.76361,0.41976 1.08698,0.74312 0.32336,0.32337 1.44761,1.09361 2.49706,1.71124 2.07836,1.22318 2.63708,1.90239 2.41168,2.92864 -0.1454,0.66202 -1.33308,1.81706 -2.4763,2.40705 -0.92233,0.47601 -1.75454,1.34332 -3.62674,3.78137 -0.77167,1.00492 -2.78064,3.42554 -4.46334,5.37953 -3.89595,4.52411 -7.57351,8.992 -13.28614,16.13977 -4.67512,5.84963 -6.32815,8.03378 -10.35404,13.67847 -1.28406,1.80037 -3.13405,4.39259 -4.11023,5.76033 -0.97619,1.36774 -1.97443,2.89811 -2.21898,3.40057 -0.24453,0.50246 -0.87115,1.39565 -1.39276,1.98588 -1.16283,1.31581 -2.71614,4.03184 -6.06265,10.59984 z" /></g></g></g></svg>
"""

SIGNAL = """<?xml version="1.0" encoding="UTF-8" standalone="no"?>
<svg
   role="img"
   focusable="false"
   aria-hidden="true"
   viewBox="0 0 14 14"
   version="1.1"
   id="svg12"
   sodipodi:docname="signal.svg"
   inkscape:version="1.2.2 (732a01da63, 2022-12-09)"
   xmlns:inkscape="http://www.inkscape.org/namespaces/inkscape"
   xmlns:sodipodi="http://sodipodi.sourceforge.net/DTD/sodipodi-0.dtd"
   xmlns="http://www.w3.org/2000/svg"
   xmlns:svg="http://www.w3.org/2000/svg">
  <defs
     id="defs16" />
  <sodipodi:namedview
     id="namedview14"
     pagecolor="#ffffff"
     bordercolor="#000000"
     borderopacity="0.25"
     inkscape:showpageshadow="2"
     inkscape:pageopacity="0.0"
     inkscape:pagecheckerboard="0"
     inkscape:deskcolor="#d1d1d1"
     showgrid="false"
     inkscape:zoom="42.274884"
     inkscape:cx="3.2052128"
     inkscape:cy="7.3093045"
     inkscape:window-width="1920"
     inkscape:window-height="1017"
     inkscape:window-x="-8"
     inkscape:window-y="-8"
     inkscape:window-maximized="1"
     inkscape:current-layer="svg12" />
  <path
     style="fill:#37474f;fill-opacity:1;stroke-width:0.0499186"
     d="M 11.675765,12.128782 C 9.0267931,12.168326 3.6663496,12.147831 3.5042119,12.09754 2.8719874,11.901432 2.1296024,11.159709 1.872636,10.46742 1.7581758,10.159057 1.7637517,9.8882153 1.961894,6.1304014 2.1520354,2.5243182 2.1863862,2.1095818 2.3043493,1.9956358 2.4233551,1.8810227 2.8112319,1.8676583 6.4486683,1.8547498 c 3.7790137,-0.01341 4.0320977,-0.0061 4.3370687,0.1253306 0.681469,0.2936835 1.382427,1.0679658 1.550284,1.7124248 0.0337,0.129404 -0.03084,1.9300465 -0.150169,4.1891652 -0.175211,3.3172896 -0.22825,3.9853226 -0.325837,4.1041536 -0.06411,0.07807 -0.146911,0.142503 -0.184203,0.142984 z"
     id="path468" />
  <rect
     style="fill:#e6e6e6;fill-opacity:1;stroke:none;stroke-width:1.57074;stroke-opacity:1"
     id="rect10749-5"
     width="7.8104901"
     height="7.8187361"
     x="3.3771245"
     y="3.1234901"
     transform="matrix(1,0,-0.04725952,0.99888264,0,0)" />
  <rect
     style="fill:#696969;fill-opacity:0.817241;stroke-width:0.402"
     id="rect28089"
     width="0.47309414"
     height="7.6168156"
     x="6.7652464"
     y="3.1933856" />
  <rect
     style="fill:#696969;fill-opacity:0.817241;stroke-width:0.402"
     id="rect28089-7"
     width="0.47309414"
     height="7.6168156"
     x="6.6469727"
     y="-10.810202"
     transform="rotate(90)" />
  <path
     style="fill:none;fill-opacity:0.817241;stroke-width:0.402;stroke:#ff0000;stroke-opacity:1"
     d="m 3.5245514,10.005941 c 0,0.09462 1.5139012,-0.5677129 1.5139012,-0.5677129 L 5.9846409,8.2081834 7.0727574,5.653475 8.2554928,4.4234302 10.195179,3.8557173"
     id="path32265" />
  <circle
     cx="8.2457867"
     cy="4.4486394"
     r="0.58283854"
     id="circle20-2"
     style="fill:#ff5555;stroke-width:0.19428" />
  <circle
     cx="7.0560775"
     cy="5.641458"
     r="0.58283854"
     id="circle22-3"
     style="fill:#ff5555;stroke-width:0.19428" />
  <circle
     cx="6.0082951"
     cy="8.2554922"
     r="0.58283854"
     id="circle24-6"
     style="fill:#ff5555;stroke-width:0.19428" />
  <circle
     cx="5.0078225"
     cy="9.4161282"
     r="0.58283854"
     id="circle26-0"
     style="fill:#ff5555;stroke-width:0.19428" />
  <circle
     cx="3.534256"
     cy="10.017958"
     r="0.58283854"
     id="circle28-1"
     style="fill:#ff5555;stroke-width:0.19428" />
  <circle
     cx="10.147869"
     cy="3.9030263"
     r="0.58283854"
     id="circle28-1-2"
     style="fill:#ff5555;stroke-width:0.19428" />
</svg>"""

IMAGE = """<?xml version="1.0" encoding="UTF-8" standalone="no"?>
<svg
   role="img"
   focusable="false"
   aria-hidden="true"
   viewBox="0 0 14 14"
   version="1.1"
   id="svg12"
   sodipodi:docname="image.svg"
   inkscape:version="1.2.2 (732a01da63, 2022-12-09)"
   xml:space="preserve"
   xmlns:inkscape="http://www.inkscape.org/namespaces/inkscape"
   xmlns:sodipodi="http://sodipodi.sourceforge.net/DTD/sodipodi-0.dtd"
   xmlns="http://www.w3.org/2000/svg"
   xmlns:svg="http://www.w3.org/2000/svg"><defs
     id="defs16" /><sodipodi:namedview
     id="namedview14"
     pagecolor="#ffffff"
     bordercolor="#000000"
     borderopacity="0.25"
     inkscape:showpageshadow="2"
     inkscape:pageopacity="0.0"
     inkscape:pagecheckerboard="0"
     inkscape:deskcolor="#d1d1d1"
     showgrid="false"
     inkscape:zoom="42.274884"
     inkscape:cx="0.082791475"
     inkscape:cy="6.0082956"
     inkscape:window-width="1920"
     inkscape:window-height="1017"
     inkscape:window-x="-8"
     inkscape:window-y="-8"
     inkscape:window-maximized="1"
     inkscape:current-layer="svg12" /><path
     style="fill:#37474f;fill-opacity:1;stroke-width:0.0499186"
     d="M 11.603869,12.127256 C 8.9548968,12.1668 3.594453,12.146305 3.4323153,12.096014 2.8000908,11.899906 2.0577058,11.158183 1.8007394,10.465894 1.6862792,10.157531 1.6918551,9.8866897 1.8899974,6.1288758 2.0801388,2.5227926 2.1144896,2.1080562 2.2324527,1.9941102 2.3514585,1.8794971 2.7393353,1.8661327 6.3767717,1.8532242 c 3.7790143,-0.01341 4.0320983,-0.0061 4.3370693,0.1253306 0.681468,0.2936835 1.382427,1.0679658 1.550284,1.7124248 0.0337,0.129404 -0.03084,1.9300465 -0.150169,4.1891652 -0.175211,3.3172892 -0.22825,3.9853222 -0.325838,4.1041532 -0.06411,0.07807 -0.14691,0.142503 -0.184203,0.142984 z"
     id="path468" /><g
     id="g22811"
     transform="matrix(0.97634529,0,-0.04619032,0.97634529,0.79214309,0.58190579)"><rect
       style="fill:#0060ff;fill-opacity:1;stroke:none;stroke-width:0.402;stroke-opacity:1"
       id="rect10749"
       width="2"
       height="2"
       x="2.5999999"
       y="2.5999999" /><rect
       style="fill:#ff7200;fill-opacity:1;stroke:none;stroke-width:0.402;stroke-opacity:1"
       id="rect10749-7"
       width="2"
       height="2"
       x="2.5999999"
       y="4.5999999" /><rect
       style="fill:#ff4300;fill-opacity:1;stroke:none;stroke-width:0.402;stroke-opacity:1"
       id="rect10749-1"
       width="2"
       height="2"
       x="4.5999999"
       y="2.5999999" /><rect
       style="fill:#ffbb00;fill-opacity:1;stroke:none;stroke-width:0.402;stroke-opacity:1"
       id="rect10749-7-5"
       width="2"
       height="2"
       x="4.5999999"
       y="4.5999999" /><rect
       style="fill:#00acff;fill-opacity:1;stroke:none;stroke-width:0.402;stroke-opacity:1"
       id="rect10749-8"
       width="2"
       height="2"
       x="6.5999999"
       y="2.5999999" /><rect
       style="fill:#ff3200;fill-opacity:1;stroke:none;stroke-width:0.402;stroke-opacity:1"
       id="rect10749-7-0"
       width="2"
       height="2"
       x="6.5999999"
       y="4.5999999" /><rect
       style="fill:#0000fb;fill-opacity:1;stroke:none;stroke-width:0.402;stroke-opacity:1"
       id="rect10749-1-4"
       width="2"
       height="2"
       x="8.6000004"
       y="2.5999999" /><rect
       style="fill:#28ffcf;fill-opacity:1;stroke:none;stroke-width:0.402;stroke-opacity:1"
       id="rect10749-7-5-5"
       width="2"
       height="2"
       x="8.6000004"
       y="4.5999999" /><rect
       style="fill:#1fffd8;fill-opacity:1;stroke:none;stroke-width:0.402;stroke-opacity:1"
       id="rect10749-84"
       width="2"
       height="2"
       x="2.5999999"
       y="6.5999999" /><rect
       style="fill:#b80000;fill-opacity:1;stroke:none;stroke-width:0.402;stroke-opacity:1"
       id="rect10749-7-8"
       width="2"
       height="2"
       x="2.5999999"
       y="8.6000004" /><rect
       style="fill:#0000cf;fill-opacity:1;stroke:none;stroke-width:0.402;stroke-opacity:1"
       id="rect10749-1-1"
       width="2"
       height="2"
       x="4.5999999"
       y="6.5999999" /><rect
       style="fill:#40ffb7;fill-opacity:1;stroke:none;stroke-width:0.402;stroke-opacity:1"
       id="rect10749-7-5-4"
       width="2"
       height="2"
       x="4.5999999"
       y="8.6000004" /><rect
       style="fill:#c4ff33;fill-opacity:1;stroke:none;stroke-width:0.402;stroke-opacity:1"
       id="rect10749-8-8"
       width="2"
       height="2"
       x="6.5999999"
       y="6.5999999" /><rect
       style="fill:#910000;fill-opacity:1;stroke:none;stroke-width:0.402;stroke-opacity:1"
       id="rect10749-7-0-4"
       width="2"
       height="2"
       x="6.5999999"
       y="8.6000004" /><rect
       style="fill:#0000ff;fill-opacity:1;stroke:none;stroke-width:0.402;stroke-opacity:1"
       id="rect10749-1-4-3"
       width="2"
       height="2"
       x="8.6000004"
       y="6.5999999" /><rect
       style="fill:#44ffb3;fill-opacity:1;stroke:none;stroke-width:0.402;stroke-opacity:1"
       id="rect10749-7-5-5-3"
       width="2"
       height="2"
       x="8.6000004"
       y="8.6000004" /></g></svg>"""

GROUP = """<?xml version="1.0" encoding="UTF-8" standalone="no"?>
<svg
   role="img"
   focusable="false"
   aria-hidden="true"
   viewBox="0 0 14 14"
   version="1.1"
   id="svg12"
   sodipodi:docname="group.svg"
   inkscape:version="1.2.2 (732a01da63, 2022-12-09)"
   xmlns:inkscape="http://www.inkscape.org/namespaces/inkscape"
   xmlns:sodipodi="http://sodipodi.sourceforge.net/DTD/sodipodi-0.dtd"
   xmlns="http://www.w3.org/2000/svg"
   xmlns:svg="http://www.w3.org/2000/svg">
  <defs
     id="defs16" />
  <sodipodi:namedview
     id="namedview14"
     pagecolor="#ffffff"
     bordercolor="#000000"
     borderopacity="0.25"
     inkscape:showpageshadow="2"
     inkscape:pageopacity="0.0"
     inkscape:pagecheckerboard="0"
     inkscape:deskcolor="#d1d1d1"
     showgrid="false"
     inkscape:zoom="42.274884"
     inkscape:cx="6.2330153"
     inkscape:cy="7.2619951"
     inkscape:window-width="1920"
     inkscape:window-height="1017"
     inkscape:window-x="-8"
     inkscape:window-y="-8"
     inkscape:window-maximized="1"
     inkscape:current-layer="svg12" />
  <path
     style="fill:#37474f;fill-opacity:1;stroke-width:0.0283859"
     d="M 6.8296648,6.2443952 C 5.1630385,5.5656538 1.8498204,4.1646697 1.7789376,4.1087109 1.5025462,3.8905091 1.4800142,3.4944286 1.7294168,3.2382259 1.8405063,3.1241066 2.0039025,3.0514944 4.345882,2.0754702 6.5932984,1.1388551 6.8595177,1.0343842 6.9999828,1.0339318 c 0.1415059,-3.633e-4 0.390015,0.09695 2.6541007,1.0402832 2.3522085,0.9800497 2.5048905,1.0479296 2.6164655,1.1632569 0.249319,0.2577033 0.226926,0.6519036 -0.04951,0.871831 -0.05551,0.044159 -1.158863,0.5197575 -2.5669417,1.1064682 C 7.5864819,6.0772998 7.159093,6.2461719 7.0283823,6.253264 6.9425113,6.257924 6.8530974,6.2539906 6.8296786,6.244414 Z"
     id="path468" />
  <path
     style="fill:#e6e6e6;fill-opacity:1;stroke-width:0.0283859"
     d="M 8.6321836,4.3315814 C 9.5064757,3.9681026 10.230488,3.6632333 10.241101,3.6540937 10.251674,3.6449595 9.5273918,3.332242 8.6315001,2.959184 L 7.0026097,2.2808951 5.3619985,2.965448 C 4.4596615,3.3419539 3.7277741,3.6507492 3.73558,3.6516593 c 0.00783,9.084e-4 0.7422977,0.3067549 1.6322008,0.6796531 0.8899054,0.3728999 1.6307817,0.6742049 1.6463938,0.6695669 0.015607,-0.00461 0.7437167,-0.3058214 1.618009,-0.6692979 z"
     id="path470" />
  <path
     style="fill:#37474f;fill-opacity:1;stroke-width:0.0283859"
     d="M 6.8296648,8.555918 C 6.7047945,8.5138635 1.9668561,6.5342623 1.8572542,6.4783472 1.7992771,6.4487701 1.72075,6.3829396 1.682745,6.3320546 1.3828407,5.9304968 1.650263,5.366658 2.1420241,5.3636968 2.2889687,5.3627885 2.4934964,5.4425038 4.6384238,6.3363819 6.122015,6.9546554 6.9974976,7.3052811 7.0370482,7.2970226 7.0713075,7.2898568 8.1340078,6.8517267 9.3986083,6.3233765 11.510477,5.4410359 11.710928,5.3628176 11.85794,5.3637005 c 0.420368,0.0025 0.706337,0.4392481 0.53752,0.8208844 C 12.31933,6.3566469 12.267463,6.4146095 12.123673,6.488199 12.061243,6.520158 10.92436,6.998606 9.5973109,7.5514122 7.1367723,8.5763955 7.0182294,8.6194195 6.8296648,8.555918 Z"
     id="path466" />
  <path
     style="fill:#475b63;fill-opacity:1;stroke-width:0.0283859"
     d="M 6.8012757,10.738642 C 6.2414245,10.520938 1.8794269,8.6854904 1.8017182,8.6349215 1.6736432,8.551578 1.5497412,8.3147523 1.5501286,8.1540355 1.5504917,8.0267197 1.653419,7.7820185 1.7384714,7.7065142 1.8523252,7.6054423 2.0631461,7.5345575 2.200317,7.551231 2.278995,7.560811 3.2500251,7.9502309 4.6555214,8.5359024 6.171646,9.1676718 7.001233,9.4994853 7.0399531,9.4896143 7.0726131,9.4812143 8.1276204,9.0454211 9.3844144,8.521022 10.755609,7.9488883 11.721549,7.5611371 11.799648,7.5514906 c 0.137204,-0.01695 0.347723,0.053715 0.461846,0.1550236 0.08505,0.075507 0.188036,0.3202055 0.188343,0.4475213 3.64e-4,0.1605988 -0.123509,0.3974956 -0.251591,0.4810624 -0.05663,0.036946 -1.213433,0.5299779 -2.5706822,1.0956284 -1.7603477,0.7336367 -2.5048743,1.0310367 -2.5973281,1.0374947 -0.071286,0.0046 -0.1743128,-0.0085 -0.2289567,-0.02957 z"
     id="path464" />
  <path
     style="fill:#576e79;fill-opacity:1;stroke-width:0.0283859"
     d="M 6.8722457,12.954603 C 6.6969628,12.909251 1.8442374,10.871475 1.7585568,10.807248 1.5332822,10.638388 1.4799938,10.238454 1.6505101,9.996368 1.6966271,9.930898 1.7918411,9.846607 1.8620975,9.809066 2.1201858,9.6711498 2.0703906,9.6546621 4.6666067,10.737631 l 2.336137,0.974492 2.3333759,-0.974308 C 11.929153,9.6551011 11.880146,9.6713468 12.137865,9.809066 c 0.07022,0.0375 0.165472,0.121825 0.211588,0.187302 0.170493,0.242052 0.11739,0.64091 -0.108041,0.81153 -0.11818,0.08944 -5.0284225,2.133784 -5.1723701,2.153474 -0.061397,0.0086 -0.1499568,0.0049 -0.196792,-0.0071 z"
     id="path438" />
</svg>"""
