#ifndef H_CDW_DROPDOWN
#define H_CDW_DROPDOWN


#include "main.h"
#include "cdw_ncurses.h"



typedef struct {

	cdw_widget_t widget;

	WINDOW *parent; /* parent window, in which a dropdown will be displayed */
	int begin_x;    /* x-coordinate of a dropdown in parent window */
	int begin_y;    /* y-coordinate of a dropdown in parent window */

	int width;      /* width of collapsed dropdown, including delimiting '[' and ']' chars */

	/* the difference between n_items_max and n_items is this:
	   when you initially create "new style" dropdown you may not know
	   exact number of items in the dropdown (which may depend on some
	   conditions), but you are sure that the number will be no larger
	   than some value. This maximal value is n_items_max, and the
	   actual number of items added to dropdown is n_items.
	   n_items_max must be specified when you call cdw_dropdown_new(),
	   and value of n_items is known when you add all necessary dropdown
	   items */
	int n_items_max;
	int n_items;

	int current_item_ind;    /* 0-based index, non-sparse */
	cdw_colors_t colors;     /* colors scheme */
	bool visible;            /* is widget visible and visitable? */
	cdw_id_label_t **items;  /* the content of the widget */

	/* internal details of implementation */
	MENU   *menu;
	ITEM  **menu_items;
	WINDOW *menu_window;
	WINDOW *menu_window_sub;

	cdw_form_widget_function_t on_select_callback;

} CDW_DROPDOWN;





CDW_DROPDOWN *cdw_dropdown_new(WINDOW *parent, int begin_y, int begin_x, int width, int n_items_max, cdw_colors_t colors);
CDW_DROPDOWN *cdw_dropdown_maker_wrapper(WINDOW *parent, int begin_y, int begin_x, int width, int n_items, cdw_id_clabel_t *items);
cdw_rv_t      cdw_dropdown_add_item(CDW_DROPDOWN *dropdown, cdw_id_t id, const char *label);
cdw_rv_t      cdw_dropdown_finalize(CDW_DROPDOWN *dropdown);
cdw_rv_t      cdw_dropdown_delete(CDW_DROPDOWN **dropdown);
void          cdw_dropdown_free(CDW_DROPDOWN *dropdown);
int           cdw_dropdown_driver(CDW_DROPDOWN *dropdown, void *dummy);
void          cdw_dropdown_display_current_item(CDW_DROPDOWN *dropdown);

void cdw_dropdown_focus(CDW_DROPDOWN *dropdown);
void cdw_dropdown_unfocus(CDW_DROPDOWN *dropdown);
void cdw_dropdown_make_visible(CDW_DROPDOWN *dropdown);
void cdw_dropdown_make_invisible(CDW_DROPDOWN *dropdown);

cdw_rv_t    cdw_dropdown_set_current_item_by_id(CDW_DROPDOWN *dropdown, cdw_id_t id);
cdw_rv_t    cdw_dropdown_set_current_item_by_ind(CDW_DROPDOWN *dropdown, int ind);
int         cdw_dropdown_get_current_item_ind(CDW_DROPDOWN *dropdown);
cdw_id_t    cdw_dropdown_get_current_item_id(CDW_DROPDOWN *dropdown);
const char *cdw_dropdown_get_current_item_label(CDW_DROPDOWN *dropdown);
const char *cdw_dropdown_get_label_by_ind(CDW_DROPDOWN *dropdown, int ind);
const char *cdw_dropdown_get_label_by_id(CDW_DROPDOWN *dropdown, cdw_id_t id);




#endif /* #ifndef H_CDW_DROPDOWN */
