#!/bin/bash
cd "$tmpdir"
source "$srcdir"/functions
initnssdb "$tmpdir"
base64 -i -d > dercert << EOF
MIIFYzCCBEugAwIBAgITHQAAAANgXaDHI7LEzAAAAAAAAzANBgkqhkiG9w0BAQUF
ADBqMRMwEQYKCZImiZPyLGQBGRYDY29tMRYwFAYKCZImiZPyLGQBGRYGcmVkaGF0
MRMwEQYKCZImiZPyLGQBGRYDYm9zMRQwEgYKCZImiZPyLGQBGRYEY2F0czEQMA4G
A1UEAxMHY2F0cy1jYTAeFw0xNTAxMjAxNzAwNTBaFw0xNzAxMTkxNzAwNTBaMCUx
CzAJBgNVBAYTAlVTMRYwFAYDVQQDEw1DQVRTLU1TQ0VQLVJBMIIBIjANBgkqhkiG
9w0BAQEFAAOCAQ8AMIIBCgKCAQEAz1HPRNKcrL1p7ukeePb6J6ERlIj7pkghJ6vF
8s4axv9nCWiYiyTKjQKOcUdd0JBnR+kiBQ0D3R8Hlt6Lpepw011Fq6e0pLV3/TkG
hlghs4S3E3yWLfPmxStKUwcOSuBftsGz3oHFcCFciPKpPHIdzix4H0hRIyvuAbt6
nYHJ5/6j8Q/9QgwnDWtz9IwzdT/kLRHTdp00B4twuGnvUo0gZ1V4/FOtlK+JOHYK
3F/nF3Zd3G5huVXnaUv4IYCVfzGmvuY+TDBXySbPMlZ9ProOw/w1pmD5EvSr45w7
3Qs02VERrmlumsRfHVClgZDpu7e0AMKzTY/JV2F0kqfyfLPP6QIDAQABo4ICRTCC
AkEwOwYJKwYBBAGCNxQCBC4eLABFAG4AcgBvAGwAbABtAGUAbgB0AEEAZwBlAG4A
dABPAGYAZgBsAGkAbgBlMBUGA1UdJQQOMAwGCisGAQQBgjcUAgEwDgYDVR0PAQH/
BAQDAgeAMB0GA1UdDgQWBBQ4+YLunQJ6VvBEBZIbvDq8uSBXOTAfBgNVHSMEGDAW
gBRgkc2jH5B+ictDORzWc8Jl3x0BKjCB0AYDVR0fBIHIMIHFMIHCoIG/oIG8hoG5
bGRhcDovLy9DTj1jYXRzLWNhLENOPWNhdHMsQ049Q0RQLENOPVB1YmxpYyUyMEtl
eSUyMFNlcnZpY2VzLENOPVNlcnZpY2VzLENOPUNvbmZpZ3VyYXRpb24sREM9Y2F0
cyxEQz1ib3MsREM9cmVkaGF0LERDPWNvbT9jZXJ0aWZpY2F0ZVJldm9jYXRpb25M
aXN0P2Jhc2U/b2JqZWN0Q2xhc3M9Y1JMRGlzdHJpYnV0aW9uUG9pbnQwgccGCCsG
AQUFBwEBBIG6MIG3MIG0BggrBgEFBQcwAoaBp2xkYXA6Ly8vQ049Y2F0cy1jYSxD
Tj1BSUEsQ049UHVibGljJTIwS2V5JTIwU2VydmljZXMsQ049U2VydmljZXMsQ049
Q29uZmlndXJhdGlvbixEQz1jYXRzLERDPWJvcyxEQz1yZWRoYXQsREM9Y29tP2NB
Q2VydGlmaWNhdGU/YmFzZT9vYmplY3RDbGFzcz1jZXJ0aWZpY2F0aW9uQXV0aG9y
aXR5MA0GCSqGSIb3DQEBBQUAA4IBAQDbwjN+OpqCmTA7Jvc+SVa22lMgOkocRqHg
FTxgs1wHFFzP+fRxJRWqAMC2+jfa5K9N/O/ftZa4tPJwahhH85HLhxX/xQlgbjq+
BDaVp27+sxMXTs7CFiKCm7pcUN+kZrDk9KpQbUchsjf405f32wh7hGpxW8YQvPkY
6XwxPHRU5o5xWaqB3rE2VxFJf47F2O8iZZOrgtF0rlbDMXfIahKw2vweWa3IQAZE
SAIRO1wEYrabyn5nJPuGi4WvEdqYEOH0ohYaBNX6Z6CG4n0/20k422HxFsNA8fJ5
hkwu1JZ5HT4ZsguDFO1Ch6b1LQk7lCw7TyOJTg+5NrdcEzZ3O/mY
EOF
base64 -i -d > derpkcs7 << EOF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EOF
cat > bundle << EOF
[!p[?3;4l[4l>
-----BEGIN CERTIFICATE-----
MIIBoDCCAQmgAwIBAAIBATANBgkqhkiG9w0BAQsFADAUMRIwEAYDVQQDEwlsb2NhbGhvc3QwIhgPMjAxNTAxMjcwMDAwMDBaGA8yMTE1MDEyNzAwMDAwMFowFDESMBAGA1UEAxMJbG9jYWxob3N0MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDT7+BazrT3e/run8ZxrTfZNFx+vY+twKMPRXowSGot2eLcdDIIryOHir1tUXIDZN2j+nF4U6kX3W66yMZjUApmYcFjhPk0Pg4ymsh/ScW2OlQXvC/fsoPhvKA6cBeWUWwpdtRnFjZ14qmGuABPi6c/p0C/04HoBR9Y6QI5voRvHwIDAQABMA0GCSqGSIb3DQEBCwUAA4GBAB4F1sjBaOJVuMmubbxc6vm3yDTwU3QwJzjmXgwGUp5QryUIBZc9Kc5ceMUJ/Xf3OFDGWOqIx4JONdcgfLRJxax9WWg4mYbkAmUQBRtl7fGgEvOqF9EgtEY06Nj5aI7vbFEfB80Xd0O9O06ckxr7QBScWc2RCeFYrUpNi6s3vfM5
-----END CERTIFICATE-----
Blah blah blah.
-----BEGIN CERTIFICATE-----
MIIBoDCCAQmgAwIBAAIBATANBgkqhkiG9w0BAQsFADAUMRIwEAYDVQQDEwlsb2NhbGhvc3QwIhgPMjAxNTAxMjcwMDAwMDBaGA8yMTE1MDEyNzAwMDAwMFowFDESMBAGA1UEAxMJbG9jYWxob3N0MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQC88Y0XCyeM/Q32FPZzASZCvnc7/8c1APYUpnI458WL2NEnQARuN+JRuDMCRxfhyplNxBwYIYGF1ufjjH7tk3Yap+g5b3cZ0054/45FOZvOJ9TdjWLWGMQPBrtDleqR9IsL5hZcriAPm3lh6F0uqtAnpNo5OV3OtxPStE5DzX02RQIDAQABMA0GCSqGSIb3DQEBCwUAA4GBAGWOrfPaXb3JH9EYl2H0mxw4camJSKfpDDfdEGzfbnmaQwQ1M/rtLGb6/sLjDqlRPATPtQOIaH1MPGNvE0nO/m4Hg7gE2QiSkoqEPrwAVFMvGtiyFnXa/LMa2KzsumCWvvu9E12n0jz7hSnEdgF5qYtIUtiKBX9jNzQZeC/b2L+v
-----END CERTIFICATE-----
Blah blah blah.
EOF
cat > recipient << EOF
-----BEGIN CERTIFICATE-----
MIIB0TCCATqgAwIBAgICEjUwDQYJKoZIhvcNAQELBQAwFDESMBAGA1UEAxMJbG9j
YWxob3N0MB4XDTcwMDEwMTExMTExMVoXDTcxMDEwMTExMTExMVowFDESMBAGA1UE
AxMJbG9jYWxob3N0MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQC394oITlJc
hLbXLUAYJ+IGpvr3YfyQlQb3u95p3s0gEemx/+Dy3ViJW7WhMuc/FHJSV5ghLflk
TRLfUdS18LGBkfkREBJVWfELhgm5ZHqiGzCvTmg01tgvouKj+8kFNJIaWsEm8mBa
SoJzk8+vOQsnXjrZAKAFY7WrVryilh4cQQIDAQABozIwMDAMBgNVHRMBAf8EAjAA
MCAGA1UdDgEBAAQWBBQfjVS9H0rXGb4SFB9bkzTpHHUH2jANBgkqhkiG9w0BAQsF
AAOBgQCt6xbyri3BobQUPQmN7ROc3mveMSfMyOwBSTDjl2XIWV98HjVLWRjScbg7
KW6z8W7iaasSDF7GWM2YqWaanWx5XwzayNUvIX3gHKqo+OwHo5QUfawtEV5Niop1
N4nZp1GMclRuk9UFXLV2NfaohRPYs7FVdBVtWNvg7hH8XedLyw==
-----END CERTIFICATE-----
EOF
cat > key << EOF
-----BEGIN PRIVATE KEY-----
MIICdQIBADANBgkqhkiG9w0BAQEFAASCAl8wggJbAgEAAoGBALf3ighOUlyEttct
QBgn4gam+vdh/JCVBve73mnezSAR6bH/4PLdWIlbtaEy5z8UclJXmCEt+WRNEt9R
1LXwsYGR+REQElVZ8QuGCblkeqIbMK9OaDTW2C+i4qP7yQU0khpawSbyYFpKgnOT
z685CydeOtkAoAVjtatWvKKWHhxBAgMBAAECgYBowoXQBQnRtaGJFzOQjeWgdCYm
CZ6RlsvI9yrIjx+wS4MQ4e1vX6yzS446pYoZ2cLgMRFok42ZGGrO0QKYOOBbOE1c
fS7FGddn/8KENW8w2kxRI2pxFXQuHBWuWdkoArhZOPxL4O+xg9dAvrwxy2pOBvpr
veZ/8siYc49ki69hgQJBAO5WSjDQ2M0aVfZOwCKm7+0tVeC6ZGS4MPH/h1oQNfSk
oB1Pbc9i/gR7M5690i9eqGvr98kGGSvlvKC6LGqgT5UCQQDFmb6DbLa3HiVn7W7b
u53rhZpnghn7OdFATxeyMDVnU6GFye5+8EhwVUDLVF7S7v8hOYOYY3HjkpzqhxkT
7B79AkBlTpZwk4VkASrC7Ixs7kqTpS6YvIHJ8iUT6ErPNI7Ks2M/sjB585kHrJqv
gf4ilni+jumfMBFpAFkidKBGnmfVAkAqKom1/9/pqZwv1kHez+V+Gc9+IQwsSQU3
JOmYk6MBvp3sL9Ad9GZw2jBucz2c43U8AMrtHONzvZiQj22xi6R9AkAYfAWQHEkc
1BQ/aKNIfymCkV/1mNcOlm6OE6jy8gJitMzFd8OrpokwGIQpTjKCMQwDtWbRouYE
GcR9Xs1JgYLI
-----END PRIVATE KEY-----
EOF
cat > csr << EOF
-----BEGIN NEW CERTIFICATE REQUEST-----
MIIBwjCCASsCAQAwFDESMBAGA1UEAxMJbG9jYWxob3N0MIGfMA0GCSqGSIb3DQEB
AQUAA4GNADCBiQKBgQC394oITlJchLbXLUAYJ+IGpvr3YfyQlQb3u95p3s0gEemx
/+Dy3ViJW7WhMuc/FHJSV5ghLflkTRLfUdS18LGBkfkREBJVWfELhgm5ZHqiGzCv
Tmg01tgvouKj+8kFNJIaWsEm8mBaSoJzk8+vOQsnXjrZAKAFY7WrVryilh4cQQID
AQABoG4wKwYJKoZIhvcNAQkUMR4eHAAyADAAMQA1ADAAMQAyADIAMgAzADIANQAx
ADMwPwYJKoZIhvcNAQkOMTIwMDAMBgNVHRMBAf8EAjAAMCAGA1UdDgEBAAQWBBQf
jVS9H0rXGb4SFB9bkzTpHHUH2jANBgkqhkiG9w0BAQsFAAOBgQAliHNkTQ35679h
9RWudkBBn5aRnp+AoRPVyPMoqr8vl4SyrMiqg+U71hbju5fEnrFi8kDHYgq0otbb
rjLR8fyXjJzhoUgY1twomdFeLvfd1Dk2DClEKGqye8rTQaatL3tq29NjqASSge1z
c9gcIfqK9dgYShx5Iy0Rshend17aBw==
-----END NEW CERTIFICATE REQUEST-----
EOF
cat > other << EOF
-----BEGIN CERTIFICATE-----
MIIBoDCCAQmgAwIBAAIBATANBgkqhkiG9w0BAQsFADAUMRIwEAYDVQQDEwls
b2NhbGhvc3QwIhgPMjAxNTAxMjcwMDAwMDBaGA8yMTE1MDEyNzAwMDAwMFow
FDESMBAGA1UEAxMJbG9jYWxob3N0MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCB
iQKBgQDT7+BazrT3e/run8ZxrTfZNFx+vY+twKMPRXowSGot2eLcdDIIryOH
ir1tUXIDZN2j+nF4U6kX3W66yMZjUApmYcFjhPk0Pg4ymsh/ScW2OlQXvC/f
soPhvKA6cBeWUWwpdtRnFjZ14qmGuABPi6c/p0C/04HoBR9Y6QI5voRvHwID
AQABMA0GCSqGSIb3DQEBCwUAA4GBAB4F1sjBaOJVuMmubbxc6vm3yDTwU3Qw
JzjmXgwGUp5QryUIBZc9Kc5ceMUJ/Xf3OFDGWOqIx4JONdcgfLRJxax9WWg4
mYbkAmUQBRtl7fGgEvOqF9EgtEY06Nj5aI7vbFEfB80Xd0O9O06ckxr7QBSc
Wc2RCeFYrUpNi6s3vfM5
-----END CERTIFICATE-----
EOF
cat > other2 << EOF

-----BEGIN CERTIFICATE-----
MIIBoDCCAQmgAwIBAAIBATANBgkqhkiG9w0BAQsFADAUMRIwEAYDVQQDEwls
b2NhbGhvc3QwIhgPMjAxNTAxMjcwMDAwMDBaGA8yMTE1MDEyNzAwMDAwMFow
FDESMBAGA1UEAxMJbG9jYWxob3N0MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCB
iQKBgQDT7+BazrT3e/run8ZxrTfZNFx+vY+twKMPRXowSGot2eLcdDIIryOH
ir1tUXIDZN2j+nF4U6kX3W66yMZjUApmYcFjhPk0Pg4ymsh/ScW2OlQXvC/f
soPhvKA6cBeWUWwpdtRnFjZ14qmGuABPi6c/p0C/04HoBR9Y6QI5voRvHwID
AQABMA0GCSqGSIb3DQEBCwUAA4GBAB4F1sjBaOJVuMmubbxc6vm3yDTwU3Qw
JzjmXgwGUp5QryUIBZc9Kc5ceMUJ/Xf3OFDGWOqIx4JONdcgfLRJxax9WWg4
mYbkAmUQBRtl7fGgEvOqF9EgtEY06Nj5aI7vbFEfB80Xd0O9O06ckxr7QBSc
Wc2RCeFYrUpNi6s3vfM5
-----END CERTIFICATE-----

EOF
cat > other3 << EOF
-----BEGIN CERTIFICATE-----
MIIBoDCCAQmgAwIBAAIBATANBgkqhkiG9w0BAQsFADAUMRIwEAYDVQQDEwls
b2NhbGhvc3QwIhgPMjAxNTAxMjcwMDAwMDBaGA8yMTE1MDEyNzAwMDAwMFow
FDESMBAGA1UEAxMJbG9jYWxob3N0MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCB
iQKBgQDT7+BazrT3e/run8ZxrTfZNFx+vY+twKMPRXowSGot2eLcdDIIryOH
ir1tUXIDZN2j+nF4U6kX3W66yMZjUApmYcFjhPk0Pg4ymsh/ScW2OlQXvC/f
soPhvKA6cBeWUWwpdtRnFjZ14qmGuABPi6c/p0C/04HoBR9Y6QI5voRvHwID
AQABMA0GCSqGSIb3DQEBCwUAA4GBAB4F1sjBaOJVuMmubbxc6vm3yDTwU3Qw
JzjmXgwGUp5QryUIBZc9Kc5ceMUJ/Xf3OFDGWOqIx4JONdcgfLRJxax9WWg4
mYbkAmUQBRtl7fGgEvOqF9EgtEY06Nj5aI7vbFEfB80Xd0O9O06ckxr7QBSc
Wc2RCeFYrUpNi6s3vfM5

EOF
echo -n -----END CERTIFICATE----- >> other3

cat > plain << EOF
This is some plaintext.
EOF
cat > entry.openssl << EOF
id=Test
key_storage_type=FILE
key_storage_location=key
EOF
cat > entry.nss << EOF
id=Test
key_storage_type=NSSDB
key_storage_location=$tmpdir
cert_storage_type=NSSDB
cert_storage_location=$tmpdir
minicert=-----BEGIN CERTIFICATE-----
 MIIB0TCCATqgAwIBAgICEjUwDQYJKoZIhvcNAQELBQAwFDESMBAGA1UEAxMJbG9j
 YWxob3N0MB4XDTcwMDEwMTExMTExMVoXDTcxMDEwMTExMTExMVowFDESMBAGA1UE
 AxMJbG9jYWxob3N0MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQC394oITlJc
 hLbXLUAYJ+IGpvr3YfyQlQb3u95p3s0gEemx/+Dy3ViJW7WhMuc/FHJSV5ghLflk
 TRLfUdS18LGBkfkREBJVWfELhgm5ZHqiGzCvTmg01tgvouKj+8kFNJIaWsEm8mBa
 SoJzk8+vOQsnXjrZAKAFY7WrVryilh4cQQIDAQABozIwMDAMBgNVHRMBAf8EAjAA
 MCAGA1UdDgEBAAQWBBQfjVS9H0rXGb4SFB9bkzTpHHUH2jANBgkqhkiG9w0BAQsF
 AAOBgQCt6xbyri3BobQUPQmN7ROc3mveMSfMyOwBSTDjl2XIWV98HjVLWRjScbg7
 KW6z8W7iaasSDF7GWM2YqWaanWx5XwzayNUvIX3gHKqo+OwHo5QUfawtEV5Niop1
 N4nZp1GMclRuk9UFXLV2NfaohRPYs7FVdBVtWNvg7hH8XedLyw==
 -----END CERTIFICATE-----
EOF
$toolsdir/pk7parse dercert
$toolsdir/pk7parse derpkcs7
$toolsdir/pk7parse other
$toolsdir/pk7parse other2
$toolsdir/pk7parse other3
$toolsdir/pk7parse bundle
echo Decrypted CSR:
$toolsdir/pk7env recipient csr | base64 -i -d | openssl smime -inform der -decrypt -inkey key recipient -binary | base64
echo Encoded issuer-and-subject:
$toolsdir/pk7env recipient recipient recipient | head -n 1
echo Decrypted issuer-and-subject:
$toolsdir/pk7env recipient recipient recipient | tail -n 1 | base64 -i -d | openssl smime -inform der -decrypt -inkey key recipient | base64
echo Encrypted plaintext, OpenSSL key:
openssl smime -in plain -outform der -encrypt recipient | $toolsdir/pk7decrypt entry.openssl
echo Encrypted plaintext, NSS key:
openssl pkcs12 -export -name testy -inkey key -in recipient -out p12 -passout pass:foo
pk12util -i p12 -d "$tmpdir" -W foo
certutil -d "$tmpdir" -D -n testy
openssl smime -in plain -outform der -encrypt recipient | $toolsdir/pk7decrypt entry.nss
