- This page contains ideas for possible new features in future versions of `ezdxf`.
-
- # Add-ons
	- ## `drawing` add-on improvements
		- LATER Support for `Layout.dxf.plot_layout_options` in export mode of class `RenderContext`
			- plot with plot-styles
				- disable loading of the ctb-table in `set_current_layout()`
			- plot entity lineweights
				- if disabled which linewidth should be used instead?
			- scale lineweights
				- scale by what?
			- plot transparencies
				- hide paperspace entities (`DXFGraphic.dxf.paperspace` attribute is `True`)
				- [[VIEWPORT]] borders are not plotted at all by the `drawing` add-on
		- LATER improve linetype rendering of wide patterns, see [#906](https://github.com/mozman/ezdxf/issue/906)
		-
	- ## DWG loader add-on
		- #maybe a DWG loader for simple documents
			- useful for scenarios where the [[ODA File Converter]] is not available
			- can not replace the [[ODA File Converter]] application, but maybe good enough for simple documents
			- Cython will be required for the low level stuff, no pure Python implementation.
-
- # DXF Entities
	- LATER [[GEODATA]] version 1 support, see mpolygon examples and DXF reference R2009
	- LATER explode [[HATCH]] pattern into [[LINE]] entities, points are represented by zero-length [[LINE]] entities, because the [[POINT]] entity has a special meaning.
	- LATER [[HATCH]] - move hatch pattern origin
		- examples/entities/hatch_pattern_modify_origin.py
		- {{discussion 769}}
	- #maybe add support for [[REGION]] entities:
		- A [[REGION]] consist of one or more flat loops that enclose a space based on [[ACIS]].
		- The [[SAT]] and [[SAB]] representation of curved edges and faces within [[ACIS]] data needs to be reverse engineered.
		- Explode curved faces into virtual [[LINE]], [[ARC]], [[ELLIPSE]] and [[SPLINE]] entities or a [[Path]] instance
	- #maybe associative arrays, [ARRAY](https://help.bricsys.com/document/_commandreference--CMD_-array/V23/EN_US?id=165079036414) command in CAD applications
-
- # Boundary Path Constructor
	- LATER A module to create boundary paths for [[HATCH]] and [[MPOLYGON]] entities.
	- The input data are DXF entities e.g. the result of a selection or an entity query, the module functions and classes help to detect closed path in the entity collection and returns one or more [[BoundaryPaths]] instances.
	- Although [[HATCH]] and [[MPOLYGON]] can contain multiple separated areas in a single entity this module should create a boundary path for each separated area.
	- All entities have to be located in the xy-plane and in a later version maybe in the same spatial plan defined by the extrusion vector and elevation.
	- When the entities are located in the xy-plane the extrusion vector of [[CIRCLE]], [[ARC]] and [[ELLIPSE]] can be inverted.
	- Simple closed paths
		- [[CIRCLE]]
		- full 360° [[ARC]]
		- full 360° [[ELLIPSE]]
		- closed [[LWPOLYLINE]] or 2D [[POLYLINE]]
		- closed [[SPLINE]]
		- [[SOLID]], [[TRACE]], [[3DFACE]]
	- #maybe subtract [[TEXT]], [[ATTRIB]] and [[MTEXT]] as text box paths
	- Complex connected paths are build from multiple entities, input entities can be
		- [[LINE]]
		- open [[ARC]]
		- open [[ELLIPSE]]
		- open [[LWPOLYLINE]] or 2D [[POLYLINE]]
		- open [[SPLINE]]
	- The path detection
		- try to connect path elements by their closest end points
		- by ambiguity the differnt possible paths are tracked recursively and the shortest 
		  or longest path will be taken.
		- A gap tolerance is given by the user to connect end points that are not coincident and the algorithm adds connection lines between these gaps.
-
- # Increase Minimal Required Python Version
	- Deprecating Python support for EOL versions:  https://devguide.python.org/versions/
	-
	- Python 3.10 (EOL Python 3.9 in 2025-10) in late 2025, after release of Python 3.14
		- https://docs.python.org/3/whatsnew/3.10.html
		- structural pattern matching
		- typing: union operator `|`, outside of annotations (type aliases)
		- dataclasses: `__slots__`
		-
	- Python 3.11  (EOL Python 3.10 in 2026-10) in late 2026, after release of Python 3.15
		- https://docs.python.org/3/whatsnew/3.11.html
		- `typing.Self`
		- `typing.overload()` decorator
		-
	- Python 3.12  (EOL Python 3.11 in 2027-10) in late 2027, after release of Python 3.16
		- https://docs.python.org/3/whatsnew/3.12.html
		- `typing.override()` decorator
		- type parameter syntax: `def max[T](args: Iterable[T]) -> T: ...`
		- use `type` for type aliases: `type Point = tuple[float, float]`
		-
	- Apply minimal Python version update to
		- pyproject.toml
		- README.md
		- toplevel index.rst
		- introduction.rst
		- setup.rst