 /*****************************************************************************
 **  This is part of the SpaceZero program
 **  Copyleft (C) 2006-2011  M.Revenga
 **
 **  This program is free software; you can redistribute it and/or modify
 **  it under the terms of the GNU General Public License (version 3), or
 **  (at your option) any later version, as published by the Free Software 
 **  Foundation.
 **
 **  This program is distributed in the hope that it will be useful,
 **  but WITHOUT ANY WARRANTY; without even the implied warranty of
 **  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 **  GNU General Public License for more details.
 **
 **  You should have received a copy of the GNU General Public License
 **  along with this program; if not, write to the Free Software
 **  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 ******************************************************************************/

/*************  SpaceZero  M.R.H. 2006-2011 ******************
		Author: M.Revenga
		E-mail: mrevenga at users.sourceforge.net
		version 0.80 May 2011
****/

#ifndef _SHELL_
#define _SHELL_

#include <gtk/gtk.h>
#include "objects.h"

#define RESET 0
#define ADD 1
#define DELETELAST 2
#define RETURNLAST 3
#define LOAD 4


struct Shell{
  char name[16];
  char menu[128];
  char par[128];
  char options[16];
  int noptions;
  int orders[16];
  int order; 
};

struct Ordername{
  int order;
  char name[12];
};


void initshell(void);
void Shell(GdkPixmap *pixmap,GdkFont *,GdkGC *,struct HeadObjList *hl,struct Player *players,struct Keys *,Object **cv);
Object *ExecOrder(struct HeadObjList *hl,Object *obj,int order,char *par);
void DrawSelectionBox(Object **,int);
int Keystrokes(int mode,char *c);

int Get2Args(char *cad,char *arg1,char *arg2);

#endif
