/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.bristol.star.cdf;

import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import uk.ac.bristol.star.cdf.AttributeEntry;
import uk.ac.bristol.star.cdf.CdfInfo;
import uk.ac.bristol.star.cdf.CdfReader;
import uk.ac.bristol.star.cdf.DataType;
import uk.ac.bristol.star.cdf.GlobalAttribute;
import uk.ac.bristol.star.cdf.Variable;
import uk.ac.bristol.star.cdf.VariableAttribute;
import uk.ac.bristol.star.cdf.record.AttributeDescriptorRecord;
import uk.ac.bristol.star.cdf.record.AttributeEntryDescriptorRecord;
import uk.ac.bristol.star.cdf.record.Buf;
import uk.ac.bristol.star.cdf.record.CdfDescriptorRecord;
import uk.ac.bristol.star.cdf.record.DataReader;
import uk.ac.bristol.star.cdf.record.GlobalDescriptorRecord;
import uk.ac.bristol.star.cdf.record.Record;
import uk.ac.bristol.star.cdf.record.RecordFactory;
import uk.ac.bristol.star.cdf.record.VariableDescriptorRecord;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CdfContent {
    private final CdfInfo cdfInfo_;
    private final GlobalAttribute[] globalAtts_;
    private final VariableAttribute[] variableAtts_;
    private final Variable[] variables_;

    public CdfContent(CdfReader cdfReader) throws IOException {
        Buf buf = cdfReader.getBuf();
        RecordFactory recordFactory = cdfReader.getRecordFactory();
        CdfDescriptorRecord cdfDescriptorRecord = cdfReader.getCdr();
        GlobalDescriptorRecord globalDescriptorRecord = recordFactory.createRecord(buf, cdfDescriptorRecord.gdrOffset, GlobalDescriptorRecord.class);
        boolean bl = Record.hasBit(cdfDescriptorRecord.flags, 0);
        int[] nArray = globalDescriptorRecord.rDimSizes;
        int n = globalDescriptorRecord.leapSecondLastUpdated;
        this.cdfInfo_ = new CdfInfo(bl, nArray, n);
        VariableDescriptorRecord[] variableDescriptorRecordArray = CdfContent.walkVariableList(buf, recordFactory, globalDescriptorRecord.nrVars, globalDescriptorRecord.rVdrHead);
        VariableDescriptorRecord[] variableDescriptorRecordArray2 = CdfContent.walkVariableList(buf, recordFactory, globalDescriptorRecord.nzVars, globalDescriptorRecord.zVdrHead);
        VariableDescriptorRecord[] variableDescriptorRecordArray3 = CdfContent.arrayConcat(variableDescriptorRecordArray, variableDescriptorRecordArray2);
        this.variables_ = new Variable[variableDescriptorRecordArray3.length];
        for (int i = 0; i < variableDescriptorRecordArray3.length; ++i) {
            this.variables_[i] = new Variable(variableDescriptorRecordArray3[i], this.cdfInfo_, recordFactory);
        }
        AttributeDescriptorRecord[] attributeDescriptorRecordArray = CdfContent.walkAttributeList(buf, recordFactory, globalDescriptorRecord.numAttr, globalDescriptorRecord.adrHead);
        ArrayList<GlobalAttribute> arrayList = new ArrayList<GlobalAttribute>();
        ArrayList<VariableAttribute> arrayList2 = new ArrayList<VariableAttribute>();
        for (int i = 0; i < attributeDescriptorRecordArray.length; ++i) {
            AttributeDescriptorRecord attributeDescriptorRecord = attributeDescriptorRecordArray[i];
            AttributeEntry[] attributeEntryArray = CdfContent.walkEntryList(buf, recordFactory, attributeDescriptorRecord.nGrEntries, attributeDescriptorRecord.maxGrEntry, attributeDescriptorRecord.agrEdrHead, this.cdfInfo_);
            AttributeEntry[] attributeEntryArray2 = CdfContent.walkEntryList(buf, recordFactory, attributeDescriptorRecord.nZEntries, attributeDescriptorRecord.maxZEntry, attributeDescriptorRecord.azEdrHead, this.cdfInfo_);
            boolean bl2 = Record.hasBit(attributeDescriptorRecord.scope, 0);
            if (bl2) {
                AttributeEntry[] attributeEntryArray3 = CdfContent.arrayConcat(attributeEntryArray, attributeEntryArray2);
                arrayList.add(new GlobalAttribute(attributeDescriptorRecord.name, attributeEntryArray3));
                continue;
            }
            arrayList2.add(new VariableAttribute(attributeDescriptorRecord.name, attributeEntryArray, attributeEntryArray2));
        }
        this.globalAtts_ = arrayList.toArray(new GlobalAttribute[0]);
        this.variableAtts_ = arrayList2.toArray(new VariableAttribute[0]);
    }

    public GlobalAttribute[] getGlobalAttributes() {
        return this.globalAtts_;
    }

    public VariableAttribute[] getVariableAttributes() {
        return this.variableAtts_;
    }

    public Variable[] getVariables() {
        return this.variables_;
    }

    public CdfInfo getCdfInfo() {
        return this.cdfInfo_;
    }

    private static VariableDescriptorRecord[] walkVariableList(Buf buf, RecordFactory recordFactory, int n, long l) throws IOException {
        VariableDescriptorRecord[] variableDescriptorRecordArray = new VariableDescriptorRecord[n];
        long l2 = l;
        for (int i = 0; i < n; ++i) {
            VariableDescriptorRecord variableDescriptorRecord;
            variableDescriptorRecordArray[i] = variableDescriptorRecord = recordFactory.createRecord(buf, l2, VariableDescriptorRecord.class);
            l2 = variableDescriptorRecord.vdrNext;
        }
        return variableDescriptorRecordArray;
    }

    private static AttributeDescriptorRecord[] walkAttributeList(Buf buf, RecordFactory recordFactory, int n, long l) throws IOException {
        AttributeDescriptorRecord[] attributeDescriptorRecordArray = new AttributeDescriptorRecord[n];
        long l2 = l;
        for (int i = 0; i < n; ++i) {
            AttributeDescriptorRecord attributeDescriptorRecord;
            attributeDescriptorRecordArray[i] = attributeDescriptorRecord = recordFactory.createRecord(buf, l2, AttributeDescriptorRecord.class);
            l2 = attributeDescriptorRecord.adrNext;
        }
        return attributeDescriptorRecordArray;
    }

    private static AttributeEntry[] walkEntryList(Buf buf, RecordFactory recordFactory, int n, int n2, long l, CdfInfo cdfInfo) throws IOException {
        AttributeEntry[] attributeEntryArray = new AttributeEntry[n2 + 1];
        long l2 = l;
        for (int i = 0; i < n; ++i) {
            AttributeEntryDescriptorRecord attributeEntryDescriptorRecord = recordFactory.createRecord(buf, l2, AttributeEntryDescriptorRecord.class);
            attributeEntryArray[attributeEntryDescriptorRecord.num] = CdfContent.readEntry(attributeEntryDescriptorRecord, cdfInfo);
            l2 = attributeEntryDescriptorRecord.aedrNext;
        }
        return attributeEntryArray;
    }

    private static AttributeEntry readEntry(AttributeEntryDescriptorRecord attributeEntryDescriptorRecord, CdfInfo cdfInfo) throws IOException {
        int n;
        int n2;
        DataType dataType = DataType.getDataType(attributeEntryDescriptorRecord.dataType, cdfInfo);
        if (dataType.hasMultipleElementsPerItem()) {
            n2 = 1;
            n = attributeEntryDescriptorRecord.numElems;
            int[] nArray = new int[]{};
            boolean[] blArray = new boolean[]{};
        } else {
            n2 = attributeEntryDescriptorRecord.numElems;
            n = 1;
            int[] nArray = new int[]{n2};
            boolean[] blArray = new boolean[]{true};
        }
        DataReader dataReader = new DataReader(dataType, n, n2);
        Object object = dataReader.createValueArray();
        dataReader.readValue(attributeEntryDescriptorRecord.getBuf(), attributeEntryDescriptorRecord.getValueOffset(), object);
        return new AttributeEntry(dataType, object, n2);
    }

    private static <T> T[] arrayConcat(T[] TArray, T[] TArray2) {
        int n = TArray.length + TArray2.length;
        ArrayList<T> arrayList = new ArrayList<T>(n);
        arrayList.addAll(Arrays.asList(TArray));
        arrayList.addAll(Arrays.asList(TArray2));
        Class<?> clazz = TArray.getClass().getComponentType();
        Object[] objectArray = arrayList.toArray((Object[])Array.newInstance(clazz, n));
        return objectArray;
    }
}

