#include "stdafx.h"
#include "Options.h"

namespace graphics {

	ImageSet *FormatOptions::loadSet(IStream *from) {
		Image *i = load(from);
		return new (this) ImageSet(i);
	}

	Image *FormatOptions::load(Url *from) {
		IStream *stream = from->read();
		try {
			Image *out = load(stream);
			stream->close();
			return out;
		} catch (...) {
			stream->close();
			throw;
		}
	}

	ImageSet *FormatOptions::loadSet(Url *from) {
		IStream *stream = from->read();
		try {
			ImageSet *out = loadSet(stream);
			stream->close();
			return out;
		} catch (...) {
			stream->close();
			throw;
		}
	}

	void FormatOptions::save(Image *image, Url *to) {
		OStream *stream = to->write();
		try {
			save(image, stream);
			stream->close();
		} catch (...) {
			stream->close();
			throw;
		}
	}

	Bool checkHeader(IStream *file, const char *header, Bool zeroTerm) {
		nat len = nat(strlen(header));
		if (zeroTerm)
			len++;

		Buffer buffer = file->peek(storm::buffer(file->engine(), len));
		if (!buffer.full()) {
			return false;
		}

		for (nat i = 0; i < len; i++) {
			if (byte(buffer[i]) != byte(header[i])) {
				return false;
			}
		}

		return true;
	}

}
